/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.accounts.organization.impl;

import java.io.Serializable;
import java.util.Set;
import javax.inject.Inject;
import org.coodex.concrete.accounts.AccountIDImpl;
import org.coodex.concrete.accounts.AccountsCommon;
import org.coodex.concrete.accounts.TenantAccount;
import org.coodex.concrete.accounts.organization.entities.AbstractPersonAccountEntity;
import org.coodex.concrete.accounts.organization.entities.AbstractPositionEntity;
import org.coodex.concrete.accounts.organization.entities.OrganizationEntity;
import org.coodex.concrete.accounts.organization.repositories.AbstractPersonAccountRepo;
import org.coodex.concrete.accounts.organization.repositories.OrganizationRepo;
import org.coodex.concrete.common.Account;
import org.coodex.concrete.common.Assert;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.core.token.TokenWrapper;
import org.coodex.util.Common;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOrgService<J extends AbstractPositionEntity, P extends AbstractPersonAccountEntity<J>> {
    private static final Logger log = LoggerFactory.getLogger(AbstractOrgService.class);
    protected Token token = TokenWrapper.getInstance();
    @Inject
    protected OrganizationRepo organizationRepo;
    @Inject
    protected AbstractPersonAccountRepo<P> personAccountRepo;

    protected void checkManagementPermission(String orgId) {
        ConcreteException exception = new ConcreteException(1006, new Object[0]);
        Account account = this.token.currentAccount();
        Set roles = account.getRoles();
        if (roles.contains("*")) {
            return;
        }
        if (roles.contains("SystemManager")) {
            return;
        }
        if (roles.contains("tenantManager")) {
            if (!Common.isBlank((String)orgId)) {
                OrganizationEntity organizationEntity = (OrganizationEntity)this.organizationRepo.findOne((Serializable)((Object)orgId));
                if (Common.isSameStr((String)organizationEntity.getTenant(), (String)AccountsCommon.getTenant())) {
                    return;
                }
            } else if (account instanceof TenantAccount) {
                TenantAccount tenantAccount = (TenantAccount)account;
                if (Common.isSameStr((String)tenantAccount.getAppSet(), (String)ConcreteHelper.getAppSet())) {
                    return;
                }
                log.info("{}(set {}) cannot use in this set: {}.", new Object[]{tenantAccount.getName(), tenantAccount.getAppSet(), ConcreteHelper.getAppSet()});
            }
        }
        if (!Common.isBlank((String)orgId)) {
            for (AbstractPositionEntity position : ((AbstractPersonAccountEntity)this.personAccountRepo.findOne((Serializable)((Object)((AccountIDImpl)account.getId()).getId()))).getPositions()) {
                if (!(position.getRoles() != null & position.getRoles().contains("OrgManager"))) continue;
                String positionBelongTo = position.getBelongTo().getId();
                for (OrganizationEntity organizationEntity = (OrganizationEntity)this.organizationRepo.findOne((Serializable)((Object)orgId)); organizationEntity != null; organizationEntity = organizationEntity.getHigherLevel()) {
                    if (!positionBelongTo.equals(organizationEntity.getId())) continue;
                    return;
                }
            }
        }
        throw exception;
    }

    protected void circleCheck(OrganizationEntity higherLevelEntity, String id) {
        for (OrganizationEntity organizationEntity = higherLevelEntity; organizationEntity != null; organizationEntity = organizationEntity.getHigherLevel()) {
            Assert.is((boolean)id.equals(organizationEntity.getId()), (int)11005, (Object[])new Object[0]);
        }
    }

    protected void checkDuplication(String higherLevel, String name, String id) {
        if (id == null) {
            Assert.notNull((Object)this.organizationRepo.findOneByTenantAndNameAndHigherLevelId(AccountsCommon.getTenant(), name, higherLevel), (int)11004, (Object[])new Object[0]);
        } else {
            Assert.notNull((Object)this.organizationRepo.findOneByTenantAndNameAndHigherLevelIdAndIdNot(AccountsCommon.getTenant(), name, higherLevel, id), (int)11004, (Object[])new Object[0]);
        }
    }

    protected OrganizationEntity checkBelongToExists(String belongTo) {
        Assert.isNull((Object)belongTo, (int)11003, (Object[])new Object[0]);
        return (OrganizationEntity)Assert.isNull((Object)this.organizationRepo.findOne((Serializable)((Object)belongTo)), (int)11003, (Object[])new Object[0]);
    }
}

