/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.accounts.organization.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.coodex.concrete.accounts.AccountsCommon;
import org.coodex.concrete.accounts.organization.api.AbstractPersonManagementService;
import org.coodex.concrete.accounts.organization.entities.AbstractPersonAccountEntity;
import org.coodex.concrete.accounts.organization.entities.AbstractPositionEntity;
import org.coodex.concrete.accounts.organization.impl.AbstractManagementService;
import org.coodex.concrete.accounts.organization.pojo.Person;
import org.coodex.concrete.accounts.organization.repositories.AbstractPersonAccountRepo;
import org.coodex.concrete.api.pojo.StrID;
import org.coodex.concrete.common.Assert;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.TwoWayCopier;
import org.coodex.util.Common;

public abstract class AbstractPersonManagementServiceImpl<J extends AbstractPositionEntity, E extends AbstractPersonAccountEntity<J>, P extends Person>
extends AbstractManagementService<J, E>
implements AbstractPersonManagementService<P> {
    @Inject
    protected TwoWayCopier<P, E> personCopier;
    @Inject
    protected AbstractPersonAccountRepo<E> personAccountRepo;

    public StrID<P> save(P person, String[] positions) {
        if (person.getCellphone() != null) {
            Assert.is((this.personAccountRepo.countByCellphoneAndTenant(person.getCellphone(), AccountsCommon.getTenant()) != 0L ? 1 : 0) != 0, (int)11010, (Object[])new Object[0]);
        }
        if (person.getIdCardNo() != null) {
            Assert.is((this.personAccountRepo.countByIdCardNoAndTenant(person.getIdCardNo(), AccountsCommon.getTenant()) != 0L ? 1 : 0) != 0, (int)11011, (Object[])new Object[0]);
        }
        if (person.getEmail() != null) {
            Assert.is((this.personAccountRepo.countByEmailAndTenant(person.getEmail(), AccountsCommon.getTenant()) != 0L ? 1 : 0) != 0, (int)11012, (Object[])new Object[0]);
        }
        AbstractPersonAccountEntity personEntity = (AbstractPersonAccountEntity)this.personCopier.copyA2B(person);
        personEntity.setPositions(this.getPositionsWithPermissionCheck(positions));
        person = (Person)this.personCopier.copyB2A(this.personAccountRepo.save((Object)personEntity), person);
        ConcreteContext.putLoggingData((String)"new", person);
        return new StrID(personEntity.getId(), person);
    }

    protected Set<J> getPositionsWithPermissionCheck(String[] positions) {
        HashSet<AbstractPositionEntity> positionEntities = new HashSet<AbstractPositionEntity>();
        for (String positionId : positions) {
            AbstractPositionEntity positionEntity = (AbstractPositionEntity)Assert.isNull((Object)this.positionRepo.findOne((Serializable)((Object)positionId)), (int)11007, (Object[])new Object[0]);
            this.checkManagementPermission(positionEntity.getBelong());
            positionEntities.add(positionEntity);
        }
        return positionEntities;
    }

    protected E getPersonEntity(String id) {
        return (E)((AbstractPersonAccountEntity)Assert.isNull((Object)this.personAccountRepo.findOne((Serializable)((Object)id)), (int)11008, (Object[])new Object[0]));
    }

    public void update(String id, P person) {
        E personEntity = this.getPersonEntityWithPermissionCheck(id);
        if (!Common.isSameStr((String)person.getCellphone(), (String)personEntity.getCellphone()) && person.getCellphone() != null) {
            Assert.is((this.personAccountRepo.countByCellphoneAndTenant(person.getCellphone(), AccountsCommon.getTenant()) != 0L ? 1 : 0) != 0, (int)11010, (Object[])new Object[0]);
        }
        if (!Common.isSameStr((String)person.getIdCardNo(), (String)personEntity.getIdCardNo()) && person.getIdCardNo() != null) {
            Assert.is((this.personAccountRepo.countByIdCardNoAndTenant(person.getIdCardNo(), AccountsCommon.getTenant()) != 0L ? 1 : 0) != 0, (int)11011, (Object[])new Object[0]);
        }
        if (!Common.isSameStr((String)person.getEmail(), (String)personEntity.getEmail()) && person.getEmail() != null) {
            Assert.is((this.personAccountRepo.countByEmailAndTenant(person.getEmail(), AccountsCommon.getTenant()) != 0L ? 1 : 0) != 0, (int)11012, (Object[])new Object[0]);
        }
        AbstractPersonAccountEntity old = (AbstractPersonAccountEntity)this.deepCopy(personEntity);
        ConcreteContext.putLoggingData((String)"old", this.deepCopy(personEntity));
        ConcreteContext.putLoggingData((String)"new", (Object)this.personAccountRepo.save(this.personCopier.copyA2B(person, personEntity)));
    }

    protected E getPersonEntityWithPermissionCheck(String id) {
        E personEntity = this.getPersonEntity(id);
        for (AbstractPositionEntity position : personEntity.getPositions()) {
            this.checkManagementPermission(position.getBelong());
        }
        return personEntity;
    }

    public void updatePositions(String id, String[] positions) {
        E personEntity = this.getPersonEntityWithPermissionCheck(id);
        ConcreteContext.putLoggingData((String)"old", this.deepCopy(personEntity));
        personEntity.setPositions(this.getPositionsWithPermissionCheck(positions));
        ConcreteContext.putLoggingData((String)"new", (Object)this.personAccountRepo.save(personEntity));
    }

    public void updateOrder(String id, Integer order) {
        this.updateOrder(order, this.getPersonEntityWithPermissionCheck(id), this.personAccountRepo);
    }

    public void delete(String id) {
        E personEntity = this.getPersonEntityWithPermissionCheck(id);
        AbstractPersonAccountEntity old = (AbstractPersonAccountEntity)this.deepCopy(personEntity);
        personEntity.setPositions(null);
        this.personAccountRepo.delete(this.personAccountRepo.save(personEntity));
        ConcreteContext.putLoggingData((String)"deleted", (Object)old);
    }

    public void grantTo(String id, String[] roles) {
        this.grantTo(this.getPersonEntityWithPermissionCheck(id), this.personAccountRepo, roles);
    }

    public Set<String> personRoles(String id) {
        return Common.join((Collection[])new Collection[]{this.getPersonEntityWithPermissionCheck(id).getRoles()});
    }

    public Set<String> allRoles(String id) {
        E personEntity = this.getPersonEntityWithPermissionCheck(id);
        Set roles = Common.join((Collection[])new Collection[]{personEntity.getRoles()});
        for (AbstractPositionEntity position : personEntity.getPositions()) {
            roles.addAll(position.getRoles());
        }
        return roles;
    }

    public void resetPassword(String id) {
        AccountsCommon.resetPassword(this.getPersonEntityWithPermissionCheck(id), this.personAccountRepo);
    }

    public void resetAuthCode(String id) {
        AccountsCommon.resetAuthCode(this.getPersonEntityWithPermissionCheck(id), this.personAccountRepo);
    }
}

