/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.accounts.organization.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import org.coodex.commons.jpa.springdata.SpecCommon;
import org.coodex.concrete.accounts.AccountsCommon;
import org.coodex.concrete.accounts.organization.api.AbstractInformationService;
import org.coodex.concrete.accounts.organization.entities.AbstractDepartmentEntity;
import org.coodex.concrete.accounts.organization.entities.AbstractInstitutionEntity;
import org.coodex.concrete.accounts.organization.entities.AbstractPersonAccountEntity;
import org.coodex.concrete.accounts.organization.entities.AbstractPositionEntity;
import org.coodex.concrete.accounts.organization.entities.OrganizationEntity;
import org.coodex.concrete.accounts.organization.impl.AbstractOrgService;
import org.coodex.concrete.accounts.organization.pojo.Department;
import org.coodex.concrete.accounts.organization.pojo.Institution;
import org.coodex.concrete.accounts.organization.pojo.Organization;
import org.coodex.concrete.accounts.organization.pojo.Person;
import org.coodex.concrete.accounts.organization.pojo.Position;
import org.coodex.concrete.accounts.organization.pojo.full.DepartmentFull;
import org.coodex.concrete.accounts.organization.pojo.full.InstitutionFull;
import org.coodex.concrete.accounts.organization.repositories.AbstractDepartmentRepo;
import org.coodex.concrete.accounts.organization.repositories.AbstractInstitutionRepo;
import org.coodex.concrete.accounts.organization.repositories.AbstractPositionRepo;
import org.coodex.concrete.api.pojo.StrID;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.common.TwoWayCopier;
import org.springframework.data.domain.Sort;

public abstract class AbstractInformationServiceImpl<I extends Institution, D extends Department, J extends Position, P extends Person, IE extends AbstractInstitutionEntity, DE extends AbstractDepartmentEntity, JE extends AbstractPositionEntity, PE extends AbstractPersonAccountEntity<JE>>
extends AbstractOrgService<JE, PE>
implements AbstractInformationService<I, D, J, P> {
    @Inject
    protected AbstractInstitutionRepo<IE> institutionRepo;
    @Inject
    protected TwoWayCopier<I, IE> institutionCopier;
    @Inject
    protected AbstractDepartmentRepo<DE> departmentRepo;
    @Inject
    protected TwoWayCopier<D, DE> departmentCopier;
    @Inject
    protected AbstractPositionRepo<JE> positionRepo;
    @Inject
    protected TwoWayCopier<J, JE> positionCopier;
    @Inject
    protected TwoWayCopier<P, PE> personCopier;

    public List<InstitutionFull<I, D, J, P>> get() {
        ArrayList<InstitutionFull<I, D, J, P>> institutionFullList = new ArrayList<InstitutionFull<I, D, J, P>>();
        for (AbstractInstitutionEntity institution : this.institutionRepo.findByTenantAndHigherLevelIdIsNullOrderByDisplayOrderDesc(AccountsCommon.getTenant())) {
            institutionFullList.add(this.$getOneInstitutionFull(institution.getId()));
        }
        return institutionFullList;
    }

    protected InstitutionFull<I, D, J, P> $getOneInstitutionFull(String id) {
        AbstractInstitutionEntity institutionEntity = (AbstractInstitutionEntity)IF.isNull((Object)this.institutionRepo.findOne((Serializable)((Object)id)), (int)11001, (Object[])new Object[0]);
        InstitutionFull institutionFull = new InstitutionFull();
        institutionFull.setId(institutionEntity.getId());
        institutionFull.setInstitution((Institution)this.institutionCopier.copyB2A((Object)institutionEntity));
        institutionFull.setInstitutions(new ArrayList());
        for (AbstractInstitutionEntity subInstitution : this.institutionRepo.findByTenantAndHigherLevelIdOrderByDisplayOrderDesc(AccountsCommon.getTenant(), institutionEntity.getId())) {
            institutionFull.getInstitutions().add(this.$getOneInstitutionFull(subInstitution.getId()));
        }
        institutionFull.setDepartments(new ArrayList());
        for (AbstractDepartmentEntity department : this.departmentRepo.findByTenantAndHigherLevelIdOrderByDisplayOrderDesc(AccountsCommon.getTenant(), institutionEntity.getId())) {
            institutionFull.getDepartments().add(this.$getOneDepartmentFull(department.getId()));
        }
        institutionFull.setPersons(new ArrayList());
        institutionFull.setPositions(new ArrayList());
        this.appendPositionsAndPersons((OrganizationEntity)institutionEntity, institutionFull.getPositions(), institutionFull.getPersons());
        return institutionFull;
    }

    protected void appendPositionsAndPersons(OrganizationEntity institutionEntity, List<StrID<J>> positionList, List<StrID<P>> personList) {
        HashSet<String> personIdSet = new HashSet<String>();
        for (AbstractPositionEntity positionEntity : this.positionRepo.findByBelongOrderByDisplayOrderDesc(institutionEntity.getId())) {
            positionList.add(new StrID(positionEntity.getId(), this.positionCopier.copyB2A((Object)positionEntity)));
            for (AbstractPersonAccountEntity personEntity : this.personAccountRepo.findAll(SpecCommon.memberOf((String)"positions", (Object)positionEntity), new Sort(new Sort.Order[]{new Sort.Order(Sort.Direction.DESC, "displayOrder")}))) {
                if (personIdSet.contains(personEntity.getId())) continue;
                personIdSet.add(personEntity.getId());
                personList.add(new StrID(personEntity.getId(), this.personCopier.copyB2A((Object)personEntity)));
            }
        }
    }

    public InstitutionFull<I, D, J, P> getOneInstitutionFull(String id) {
        return this.$getOneInstitutionFull(id);
    }

    protected DepartmentFull<D, J, P> $getOneDepartmentFull(String id) {
        AbstractDepartmentEntity departmentEntity = (AbstractDepartmentEntity)IF.isNull((Object)this.departmentRepo.findOne((Serializable)((Object)id)), (int)11002, (Object[])new Object[0]);
        DepartmentFull departmentFull = new DepartmentFull();
        departmentFull.setDepartment((Department)this.departmentCopier.copyB2A((Object)departmentEntity));
        departmentFull.setId(departmentEntity.getId());
        departmentFull.setPersons(new ArrayList());
        departmentFull.setPositions(new ArrayList());
        this.appendPositionsAndPersons((OrganizationEntity)departmentEntity, departmentFull.getPositions(), departmentFull.getPersons());
        return departmentFull;
    }

    public DepartmentFull<D, J, P> getOneDepartmentFull(String id) {
        return this.$getOneDepartmentFull(id);
    }

    public List<StrID<Organization>> getHigherLevelOrganizations(String id) {
        OrganizationEntity organizationEntity = ((OrganizationEntity)IF.isNull((Object)this.organizationRepo.findOne((Serializable)((Object)id)), (int)11003, (Object[])new Object[0])).getHigherLevel();
        ArrayList<StrID> organizationList = new ArrayList<StrID>();
        while (organizationEntity != null) {
            organizationList.add(new StrID(organizationEntity.getId(), (Object)(organizationEntity instanceof AbstractDepartmentEntity ? (Organization)this.departmentCopier.copyB2A((Object)((AbstractDepartmentEntity)organizationEntity)) : (Organization)this.institutionCopier.copyB2A((Object)((AbstractInstitutionEntity)organizationEntity)))));
        }
        StrID[] array = organizationList.toArray(new StrID[0]);
        int l = array.length;
        int h = l / 2;
        for (int i = 0; i < h; ++i) {
            StrID temp = array[i];
            array[i] = array[l - 1 - i];
            array[l - 1 - i] = temp;
        }
        return Arrays.asList(array);
    }

    public StrID<I> getInstitution(String id) {
        AbstractInstitutionEntity institutionEntity = (AbstractInstitutionEntity)IF.isNull((Object)this.institutionRepo.findOne((Serializable)((Object)id)), (int)11001, (Object[])new Object[0]);
        return new StrID(institutionEntity.getId(), this.institutionCopier.copyB2A((Object)institutionEntity));
    }

    public List<StrID<I>> getInstitutions() {
        ArrayList<StrID<I>> list = new ArrayList<StrID<I>>();
        for (AbstractInstitutionEntity institutionEntity : this.institutionRepo.findByTenantAndHigherLevelIdIsNullOrderByDisplayOrderDesc(AccountsCommon.getTenant())) {
            list.add(new StrID(institutionEntity.getId(), this.institutionCopier.copyB2A((Object)institutionEntity)));
        }
        return list;
    }

    public List<StrID<I>> getInstitutionsOf(String higherLevel) {
        if (higherLevel != null) {
            this.checkBelongToExists(higherLevel);
        }
        ArrayList<StrID<I>> list = new ArrayList<StrID<I>>();
        for (AbstractInstitutionEntity institutionEntity : this.institutionRepo.findByTenantAndHigherLevelIdOrderByDisplayOrderDesc(AccountsCommon.getTenant(), higherLevel)) {
            list.add(new StrID(institutionEntity.getId(), this.institutionCopier.copyB2A((Object)institutionEntity)));
        }
        return list;
    }

    @Deprecated
    public List<StrID<D>> getDepartmentsOfInstitution(String institution) {
        IF.isNull((Object)this.institutionRepo.findOne((Serializable)((Object)institution)), (int)11001, (Object[])new Object[0]);
        return this.$getDepartmentsOfOrganization(institution);
    }

    @Deprecated
    public List<StrID<J>> getPositionsOfInstitution(String institution) {
        IF.isNull((Object)this.institutionRepo.findOne((Serializable)((Object)institution)), (int)11001, (Object[])new Object[0]);
        return this.$getPositionsOfOrganization(institution);
    }

    @Deprecated
    public List<StrID<P>> getPersonsOfInstitution(String institution) {
        IF.isNull((Object)this.institutionRepo.findOne((Serializable)((Object)institution)), (int)11001, (Object[])new Object[0]);
        return this.$getPersonsOfOrganization(institution);
    }

    @Deprecated
    public List<StrID<D>> getDepartmentsOfDepartment(String department) {
        IF.isNull((Object)this.departmentRepo.findOne((Serializable)((Object)department)), (int)11002, (Object[])new Object[0]);
        return this.$getDepartmentsOfOrganization(department);
    }

    @Deprecated
    public List<StrID<J>> getPositionsOfDepartment(String department) {
        IF.isNull((Object)this.departmentRepo.findOne((Serializable)((Object)department)), (int)11002, (Object[])new Object[0]);
        return this.$getPositionsOfOrganization(department);
    }

    @Deprecated
    public List<StrID<P>> getPersonsOfDepartment(String department) {
        IF.isNull((Object)this.departmentRepo.findOne((Serializable)((Object)department)), (int)11002, (Object[])new Object[0]);
        return this.$getPersonsOfOrganization(department);
    }

    protected List<StrID<D>> $getDepartmentsOfOrganization(String organization) {
        this.checkBelongToExists(organization);
        ArrayList<StrID<D>> list = new ArrayList<StrID<D>>();
        for (AbstractDepartmentEntity departmentEntity : this.departmentRepo.findByTenantAndHigherLevelIdOrderByDisplayOrderDesc(AccountsCommon.getTenant(), organization)) {
            list.add(new StrID(departmentEntity.getId(), this.departmentCopier.copyB2A((Object)departmentEntity)));
        }
        return list;
    }

    public List<StrID<D>> getDepartmentsOfOrganization(String organization) {
        return this.$getDepartmentsOfOrganization(organization);
    }

    protected List<StrID<J>> $getPositionsOfOrganization(String organization) {
        this.checkBelongToExists(organization);
        ArrayList<StrID<J>> list = new ArrayList<StrID<J>>();
        for (AbstractPositionEntity positionEntity : this.positionRepo.findByBelongOrderByDisplayOrderDesc(organization)) {
            list.add(new StrID(positionEntity.getId(), this.positionCopier.copyB2A((Object)positionEntity)));
        }
        return list;
    }

    public List<StrID<J>> getPositionsOfOrganization(String organization) {
        return this.$getPositionsOfOrganization(organization);
    }

    protected List<StrID<P>> $getPersonsOfOrganization(String organization) {
        ArrayList<StrID<P>> personList = new ArrayList<StrID<P>>();
        this.appendPositionsAndPersons(this.checkBelongToExists(organization), new ArrayList<StrID<J>>(), personList);
        return personList;
    }

    public List<StrID<P>> getPersonsOfOrganization(String organization) {
        return this.$getPersonsOfOrganization(organization);
    }

    public List<StrID<I>> getInstitutionsOfPerson(String person) {
        AbstractPersonAccountEntity personEntity = (AbstractPersonAccountEntity)IF.isNull((Object)this.personAccountRepo.findOne((Serializable)((Object)person)), (int)11008, (Object[])new Object[0]);
        HashSet<String> institutions = new HashSet<String>();
        ArrayList<StrID<I>> institutionList = new ArrayList<StrID<I>>();
        for (AbstractPositionEntity positionEntity : personEntity.getPositions()) {
            for (OrganizationEntity organizationEntity = positionEntity.getBelongTo(); organizationEntity != null; organizationEntity = organizationEntity.getHigherLevel()) {
                if (!(organizationEntity instanceof AbstractInstitutionEntity) || institutions.contains(organizationEntity.getId())) continue;
                institutions.add(organizationEntity.getId());
                institutionList.add(new StrID(organizationEntity.getId(), this.institutionCopier.copyB2A((Object)((AbstractInstitutionEntity)organizationEntity))));
            }
        }
        return institutionList;
    }

    public List<StrID<D>> getDepartmentsOfPerson(String person) {
        AbstractPersonAccountEntity personEntity = (AbstractPersonAccountEntity)IF.isNull((Object)this.personAccountRepo.findOne((Serializable)((Object)person)), (int)11008, (Object[])new Object[0]);
        HashSet<String> departments = new HashSet<String>();
        ArrayList<StrID<D>> departmentList = new ArrayList<StrID<D>>();
        for (AbstractPositionEntity positionEntity : personEntity.getPositions()) {
            for (OrganizationEntity organizationEntity = positionEntity.getBelongTo(); organizationEntity != null && organizationEntity instanceof AbstractDepartmentEntity; organizationEntity = organizationEntity.getHigherLevel()) {
                if (departments.contains(organizationEntity.getId())) continue;
                departments.add(organizationEntity.getId());
                departmentList.add(new StrID(organizationEntity.getId(), this.departmentCopier.copyB2A((Object)((AbstractDepartmentEntity)organizationEntity))));
            }
        }
        return departmentList;
    }

    public List<StrID<J>> getPositionsOfPerson(String person) {
        AbstractPersonAccountEntity personEntity = (AbstractPersonAccountEntity)IF.isNull((Object)this.personAccountRepo.findOne((Serializable)((Object)person)), (int)11008, (Object[])new Object[0]);
        ArrayList<StrID<J>> positionList = new ArrayList<StrID<J>>();
        for (AbstractPositionEntity positionEntity : personEntity.getPositions()) {
            positionList.add(new StrID(positionEntity.getId(), this.positionCopier.copyB2A((Object)positionEntity)));
        }
        return positionList;
    }
}

