/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.accounts.organization.impl;

import java.io.Serializable;
import javax.inject.Inject;
import org.coodex.concrete.accounts.organization.api.AbstractInstitutionManagementService;
import org.coodex.concrete.accounts.organization.entities.AbstractInstitutionEntity;
import org.coodex.concrete.accounts.organization.entities.AbstractPersonAccountEntity;
import org.coodex.concrete.accounts.organization.entities.AbstractPositionEntity;
import org.coodex.concrete.accounts.organization.entities.OrganizationEntity;
import org.coodex.concrete.accounts.organization.impl.AbstractManagementService;
import org.coodex.concrete.accounts.organization.pojo.Institution;
import org.coodex.concrete.accounts.organization.repositories.AbstractInstitutionRepo;
import org.coodex.concrete.api.pojo.StrID;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.common.TwoWayCopier;
import org.coodex.util.Common;

public abstract class AbstractInstitutionManagementServiceImpl<I extends Institution, E extends AbstractInstitutionEntity, J extends AbstractPositionEntity, P extends AbstractPersonAccountEntity<J>>
extends AbstractManagementService<J, P>
implements AbstractInstitutionManagementService<I> {
    @Inject
    protected TwoWayCopier<I, E> institutionCopier;
    @Inject
    protected AbstractInstitutionRepo<E> institutionRepo;

    public StrID<I> save(I institution, String higherLevel) {
        this.checkManagementPermission(higherLevel);
        this.getInstitutionEntityNullSafe(higherLevel);
        this.checkDuplication(higherLevel, institution.getName(), null);
        AbstractInstitutionEntity institutionEntity = (AbstractInstitutionEntity)this.institutionCopier.copyA2B(institution);
        institutionEntity.setHigherLevel(Common.isBlank((String)higherLevel) ? null : this.checkBelongToExists(higherLevel));
        ConcreteContext.putLoggingData((String)"new", (Object)institutionEntity);
        return new StrID(institutionEntity.getId(), this.institutionCopier.copyB2A(this.institutionRepo.save((Object)institutionEntity), institution));
    }

    private E getInstitutionEntity(String id) {
        IF.isNull((Object)id, (int)11001, (Object[])new Object[0]);
        return (E)((AbstractInstitutionEntity)IF.isNull((Object)this.institutionRepo.findOne((Serializable)((Object)id)), (int)11001, (Object[])new Object[0]));
    }

    public void update(String id, I institution) {
        this.checkManagementPermission(id);
        E institutionEntity = this.getInstitutionEntity(id);
        this.checkDuplication(institutionEntity.getHigherLevelId(), institution.getName(), id);
        ConcreteContext.putLoggingData((String)"old", this.deepCopy(institutionEntity));
        ConcreteContext.putLoggingData((String)"new", (Object)this.institutionRepo.save(this.institutionCopier.copyA2B(institution, institutionEntity)));
    }

    private E getInstitutionEntityNullSafe(String id) {
        return id == null ? null : (E)this.getInstitutionEntity(id);
    }

    public void updateHigherLevel(String id, String higherLevel) {
        this.checkManagementPermission(id);
        this.checkManagementPermission(higherLevel);
        E higherLevelEntity = this.getInstitutionEntityNullSafe(higherLevel);
        E institutionEntity = this.getInstitutionEntity(id);
        this.checkManagementPermission(institutionEntity.getHigherLevelId());
        if (!Common.sameString((String)higherLevel, (String)institutionEntity.getHigherLevelId())) {
            this.circleCheck((OrganizationEntity)higherLevelEntity, id);
            OrganizationEntity originalEntity = institutionEntity.getHigherLevel();
            institutionEntity.setHigherLevel(Common.isBlank((String)higherLevel) ? null : this.checkBelongToExists(higherLevel));
            this.institutionRepo.save(institutionEntity);
            ConcreteContext.putLoggingData((String)"original", (Object)originalEntity);
            ConcreteContext.putLoggingData((String)"target", higherLevelEntity);
        }
    }

    public void updateOrder(String id, Integer order) {
        this.checkManagementPermission(id);
        this.updateOrder(order, this.getInstitutionEntity(id), this.institutionRepo);
    }

    public void delete(String id) {
        this.checkManagementPermission(id);
        ConcreteContext.putLoggingData((String)"deleted", this.deleteOrganization((OrganizationEntity)this.getInstitutionEntity(id)));
    }
}

