/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.accounts.organization.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.coodex.concrete.accounts.AccountIDImpl;
import org.coodex.concrete.accounts.organization.entities.AbstractPersonAccountEntity;
import org.coodex.concrete.accounts.organization.entities.AbstractPositionEntity;
import org.coodex.concrete.accounts.organization.entities.OrganizationEntity;
import org.coodex.concrete.accounts.organization.impl.OrganizationAccount;
import org.coodex.concrete.accounts.organization.repositories.AbstractPersonAccountRepo;
import org.coodex.concrete.common.AbstractCopier;
import org.coodex.concrete.common.AcceptableAccountFactory;
import org.coodex.concrete.common.Account;
import org.coodex.concrete.common.AccountID;
import org.coodex.concrete.common.ConcreteCache;
import org.coodex.concrete.common.Copier;
import org.coodex.concrete.common.IF;
import org.coodex.util.Common;

public abstract class AbstractOrganizationAccountFactory<J extends AbstractPositionEntity, P extends AbstractPersonAccountEntity<J>>
implements AcceptableAccountFactory<AccountIDImpl> {
    @Inject
    protected AbstractPersonAccountRepo<P> accountRepo;
    private Copier<P, OrganizationAccount> accountCopier = new AbstractCopier<P, OrganizationAccount>(){

        public OrganizationAccount copy(P p, OrganizationAccount organizationAccount) {
            organizationAccount.setId(new AccountIDImpl(1, p.getId()));
            organizationAccount.setName(p.getName());
            organizationAccount.setRoles(AbstractOrganizationAccountFactory.getAllRoles(p));
            organizationAccount.setTenant(p.getTenant());
            return organizationAccount;
        }
    };
    private ConcreteCache<String, OrganizationAccount> accountCache = new ConcreteCache<String, OrganizationAccount>(){

        protected OrganizationAccount load(String key) {
            AbstractPersonAccountEntity person = (AbstractPersonAccountEntity)AbstractOrganizationAccountFactory.this.accountRepo.findOne((Serializable)((Object)key));
            return person == null ? null : (OrganizationAccount)AbstractOrganizationAccountFactory.this.accountCopier.copy((Object)person);
        }

        protected String getRule() {
            return AbstractOrganizationAccountFactory.class.getPackage().getName();
        }
    };

    public static Set<String> getAllRoles(AbstractPersonAccountEntity<? extends AbstractPositionEntity> p) {
        HashSet<String> roles = new HashSet<String>();
        if (p.getPositions() != null) {
            for (AbstractPositionEntity position : p.getPositions()) {
                Set positionRoles = Common.join((Collection[])new Collection[]{p.getRoles(), position.getRoles()});
                String domain = AbstractOrganizationAccountFactory.getDomain(position);
                boolean blankDomain = Common.isBlank((String)domain);
                for (String role : positionRoles) {
                    roles.add(role);
                    if (blankDomain || role.startsWith(domain + ".")) continue;
                    roles.add(domain + "." + role);
                }
                roles.addAll(Common.join((Collection[])new Collection[]{position.getRoles()}));
            }
        }
        return Common.join((Collection[])new Collection[]{roles, p.getRoles()});
    }

    public static String getDomain(AbstractPositionEntity position) {
        OrganizationEntity organizationEntity = position.getBelongTo();
        StringBuilder domain = new StringBuilder();
        while (organizationEntity != null) {
            String orgDomain = Common.trim((String)organizationEntity.getDomain(), (char[])new char[]{'.'});
            if (!Common.isBlank((String)orgDomain)) {
                if (domain.length() != 0) {
                    domain.append('.');
                }
                domain.append(orgDomain);
            }
            organizationEntity = Common.isBlank((String)organizationEntity.getHigherLevelId()) ? null : organizationEntity.getHigherLevel();
        }
        return domain.toString();
    }

    public boolean accept(AccountIDImpl accountID) {
        return accountID != null && accountID.getType() == 1;
    }

    public <ID extends AccountID> Account<ID> getAccountByID(ID id) {
        return (Account)IF.isNull((Object)this.accountCache.get((Object)((AccountIDImpl)id).getId()), (int)10001, (Object[])new Object[0]);
    }
}

