/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.accounts.organization.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.coodex.concrete.accounts.organization.api.AbstractPositionManagementService;
import org.coodex.concrete.accounts.organization.entities.AbstractPersonAccountEntity;
import org.coodex.concrete.accounts.organization.entities.AbstractPositionEntity;
import org.coodex.concrete.accounts.organization.entities.OrganizationEntity;
import org.coodex.concrete.accounts.organization.impl.AbstractManagementService;
import org.coodex.concrete.accounts.organization.pojo.Position;
import org.coodex.concrete.api.pojo.StrID;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.common.TwoWayCopier;
import org.coodex.util.Common;

@Transactional(rollbackOn={Throwable.class})
public abstract class AbstractPositionManagementServiceImpl<J extends Position, E extends AbstractPositionEntity, P extends AbstractPersonAccountEntity<E>>
extends AbstractManagementService<E, P>
implements AbstractPositionManagementService<J> {
    @Inject
    protected TwoWayCopier<J, E> positionCopier;

    public StrID<J> save(J position, String belong) {
        this.checkManagementPermission(belong);
        AbstractPositionEntity positionEntity = (AbstractPositionEntity)this.positionCopier.copyA2B(position);
        positionEntity.setBelongTo(this.checkBelongToExists(belong));
        ConcreteContext.putLoggingData((String)"new", (Object)positionEntity);
        return new StrID(positionEntity.getId(), this.positionCopier.copyB2A(this.getPositionRepo().save((Object)positionEntity), position));
    }

    protected E getPositionEntity(String id) {
        return (E)((AbstractPositionEntity)IF.isNull((Object)this.getPositionRepo().findOne((Serializable)((Object)id)), (int)11007, (Object[])new Object[0]));
    }

    protected E getPositionWithPermissionCheck(String id) {
        E positionEntity = this.getPositionEntity(id);
        this.checkManagementPermission(positionEntity.getBelong());
        return positionEntity;
    }

    public void update(String id, J position) {
        E positionEntity = this.getPositionWithPermissionCheck(id);
        ConcreteContext.putLoggingData((String)"old", this.deepCopy(positionEntity));
        ConcreteContext.putLoggingData((String)"new", (Object)this.getPositionRepo().save(this.positionCopier.copyA2B(position, positionEntity)));
    }

    public void updateBelongTo(String id, String belong) {
        E positionEntity = this.getPositionWithPermissionCheck(id);
        this.checkManagementPermission(belong);
        OrganizationEntity organizationEntity = this.checkBelongToExists(belong);
        if (!positionEntity.getBelongTo().getId().equals(belong)) {
            ConcreteContext.putLoggingData((String)"target", (Object)organizationEntity);
            ConcreteContext.putLoggingData((String)"original", (Object)positionEntity.getBelongTo());
            positionEntity.setBelongTo(organizationEntity);
            this.getPositionRepo().save(positionEntity);
        }
    }

    public void updateOrder(String id, Integer order) {
        E positionEntity = this.getPositionWithPermissionCheck(id);
        this.updateOrder(order, positionEntity, this.getPositionRepo());
    }

    public void delete(String id) {
        ConcreteContext.putLoggingData((String)"deleted", this.deletePosition(this.getPositionWithPermissionCheck(id)));
    }

    public void grantTo(String id, String[] roles) {
        this.grantTo(this.getPositionWithPermissionCheck(id), this.getPositionRepo(), roles);
    }

    public Set<String> roles(String id) {
        return Common.join((Collection[])new Collection[]{this.getPositionWithPermissionCheck(id).getRoles()});
    }
}

