/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.accounts.organization.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.coodex.concrete.accounts.AccountIDImpl;
import org.coodex.concrete.accounts.AccountsCommon;
import org.coodex.concrete.accounts.organization.api.AbstractSelfManagementService;
import org.coodex.concrete.accounts.organization.entities.AbstractDepartmentEntity;
import org.coodex.concrete.accounts.organization.entities.AbstractInstitutionEntity;
import org.coodex.concrete.accounts.organization.entities.AbstractPersonAccountEntity;
import org.coodex.concrete.accounts.organization.entities.AbstractPositionEntity;
import org.coodex.concrete.accounts.organization.entities.OrganizationEntity;
import org.coodex.concrete.accounts.organization.impl.AbstractOrganizationAccountFactory;
import org.coodex.concrete.accounts.organization.pojo.Department;
import org.coodex.concrete.accounts.organization.pojo.Institution;
import org.coodex.concrete.accounts.organization.pojo.Person;
import org.coodex.concrete.accounts.organization.pojo.Position;
import org.coodex.concrete.accounts.organization.repositories.AbstractPersonAccountRepo;
import org.coodex.concrete.api.pojo.StrID;
import org.coodex.concrete.common.Account;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.common.TenantBuilderWrapper;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.common.TwoWayCopier;
import org.coodex.concrete.core.token.TokenWrapper;
import org.coodex.util.Common;

public abstract class AbstractSelfManagementServiceImpl<I extends Institution, D extends Department, J extends Position, P extends Person, IE extends AbstractInstitutionEntity, DE extends AbstractDepartmentEntity, JE extends AbstractPositionEntity, PE extends AbstractPersonAccountEntity<JE>>
implements AbstractSelfManagementService<I, D, J, P> {
    protected Token token = TokenWrapper.getInstance();
    @Inject
    protected AbstractPersonAccountRepo<PE> personAccountRepo;
    @Inject
    protected TwoWayCopier<I, IE> institutionCopier;
    @Inject
    protected TwoWayCopier<D, DE> departmentCopier;
    @Inject
    protected TwoWayCopier<J, JE> positionCopier;

    protected String getTenant() {
        return TenantBuilderWrapper.getInstance().getTenant();
    }

    protected PE getCurrentAccountEntity() {
        Account currentAccount = this.token.currentAccount();
        IF.is((((AccountIDImpl)currentAccount.getId()).getType() != 1 ? 1 : 0) != 0, (int)11009, (Object[])new Object[0]);
        return (PE)((AbstractPersonAccountEntity)this.personAccountRepo.findOne((Serializable)((Object)((AccountIDImpl)currentAccount.getId()).getId())));
    }

    public List<StrID<I>> getMyInstitutions() {
        HashSet<String> institutionIdSet = new HashSet<String>();
        ArrayList<StrID<I>> institutions = new ArrayList<StrID<I>>();
        PE personEntity = this.getCurrentAccountEntity();
        for (AbstractPositionEntity position : personEntity.getPositions()) {
            AbstractInstitutionEntity institutionEntity = null;
            OrganizationEntity organizationEntity = position.getBelongTo();
            while (organizationEntity instanceof AbstractDepartmentEntity && (organizationEntity = organizationEntity.getHigherLevel()) != null) {
            }
            for (institutionEntity = (AbstractInstitutionEntity)organizationEntity; institutionEntity != null; institutionEntity = (AbstractInstitutionEntity)institutionEntity.getHigherLevel()) {
                if (institutionIdSet.contains(institutionEntity.getId())) continue;
                institutionIdSet.add(institutionEntity.getId());
                institutions.add(new StrID(institutionEntity.getId(), this.institutionCopier.copyB2A((Object)institutionEntity)));
            }
        }
        return institutions;
    }

    public List<StrID<D>> getMyDepartments() {
        HashSet<String> departmentIdSet = new HashSet<String>();
        ArrayList<StrID<D>> departments = new ArrayList<StrID<D>>();
        PE personEntity = this.getCurrentAccountEntity();
        for (AbstractPositionEntity position : personEntity.getPositions()) {
            OrganizationEntity organizationEntity = position.getBelongTo();
            while (organizationEntity instanceof AbstractDepartmentEntity) {
                AbstractDepartmentEntity departmentEntity = (AbstractDepartmentEntity)organizationEntity;
                if (!departmentIdSet.contains(departmentEntity.getId())) {
                    departmentIdSet.add(departmentEntity.getId());
                    departments.add(new StrID(departmentEntity.getId(), this.departmentCopier.copyB2A((Object)departmentEntity)));
                }
                organizationEntity = departmentEntity.getHigherLevel();
            }
        }
        return departments;
    }

    public List<StrID<J>> getMyPositions() {
        ArrayList<StrID<J>> positions = new ArrayList<StrID<J>>();
        PE personEntity = this.getCurrentAccountEntity();
        for (AbstractPositionEntity position : personEntity.getPositions()) {
            positions.add(new StrID(position.getId(), this.positionCopier.copyB2A((Object)position)));
        }
        return positions;
    }

    public Set<String> getMyRoles() {
        return AbstractOrganizationAccountFactory.getAllRoles(this.getCurrentAccountEntity());
    }

    public void updatePassword(String password, String authCode) {
        AccountsCommon.updatePassword(this.getCurrentAccountEntity(), (String)password, (String)authCode, this.personAccountRepo);
    }

    public void updateCellPhone(String cellPhone, String authCode) {
        AbstractPersonAccountEntity personEntity = (AbstractPersonAccountEntity)AccountsCommon.checkAuthCode((String)authCode, this.getCurrentAccountEntity());
        if (!Common.isSameStr((String)cellPhone, (String)personEntity.getCellphone())) {
            if (cellPhone != null) {
                IF.is((this.personAccountRepo.countByCellphoneAndTenant(cellPhone, this.getTenant()) != 0L ? 1 : 0) != 0, (int)11010, (Object[])new Object[0]);
            }
            personEntity.setCellphone(cellPhone);
            ConcreteContext.putLoggingData((String)"cellPhone", (Object)cellPhone);
            this.personAccountRepo.save((Object)personEntity);
        }
    }

    public void updateEmail(String email, String authCode) {
        AbstractPersonAccountEntity personEntity = (AbstractPersonAccountEntity)AccountsCommon.checkAuthCode((String)authCode, this.getCurrentAccountEntity());
        if (!Common.isSameStr((String)email, (String)personEntity.getEmail())) {
            if (email != null) {
                IF.is((this.personAccountRepo.countByEmailAndTenant(email, this.getTenant()) != 0L ? 1 : 0) != 0, (int)11012, (Object[])new Object[0]);
            }
            personEntity.setEmail(email);
            ConcreteContext.putLoggingData((String)"email", (Object)email);
            this.personAccountRepo.save((Object)personEntity);
        }
    }

    public String authenticatorDesc(String authCode) {
        return AccountsCommon.getAuthenticatorDesc(this.getCurrentAccountEntity(), (String)authCode);
    }

    public void bindAuthKey(String authCode) {
        AccountsCommon.bindAuthKey(this.getCurrentAccountEntity(), (String)authCode, this.personAccountRepo);
    }
}

