/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.accounts.organization.impl;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.coodex.concrete.accounts.organization.entities.AbstractPersonAccountEntity;
import org.coodex.concrete.accounts.organization.entities.AbstractPositionEntity;
import org.coodex.concrete.accounts.organization.entities.OrganizationEntity;
import org.coodex.concrete.accounts.organization.impl.OrganizationAccount;
import org.coodex.concrete.accounts.organization.repositories.AbstractPersonAccountRepo;
import org.coodex.concrete.common.Account;
import org.coodex.concrete.common.ClassifiableAccountFactory;
import org.coodex.concrete.common.ClassifiableAccountID;
import org.coodex.concrete.common.IF;
import org.coodex.config.Config;
import org.coodex.copier.AbstractCopier;
import org.coodex.copier.Copier;
import org.coodex.util.Common;
import org.coodex.util.SingletonMap;

public abstract class AbstractOrganizationAccountFactory<J extends AbstractPositionEntity, P extends AbstractPersonAccountEntity<J>>
extends ClassifiableAccountFactory {
    @Inject
    protected AbstractPersonAccountRepo<P> accountRepo;
    private Copier<P, OrganizationAccount> accountCopier = new AbstractCopier<P, OrganizationAccount>(){

        public OrganizationAccount copy(P p, OrganizationAccount organizationAccount) {
            organizationAccount.setId(new ClassifiableAccountID(Integer.valueOf(1), p.getId()));
            organizationAccount.setName(p.getName());
            organizationAccount.setRoles(AbstractOrganizationAccountFactory.getAllRoles(p));
            organizationAccount.setTenant(p.getTenant());
            return organizationAccount;
        }
    };
    private SingletonMap<String, OrganizationAccount> accountSingletonMap = new SingletonMap((SingletonMap.Builder)new SingletonMap.Builder<String, OrganizationAccount>(){

        public OrganizationAccount build(String key) {
            AbstractPersonAccountEntity person = AbstractOrganizationAccountFactory.this.accountRepo.findById((Object)key).orElse(null);
            return person == null ? null : (OrganizationAccount)AbstractOrganizationAccountFactory.this.accountCopier.copy((Object)person);
        }
    }, (long)((Integer)Config.getValue((String)"cache.object.life", (Object)10, (String[])new String[]{AbstractOrganizationAccountFactory.class.getPackage().getName()}) * 60 * 1000));

    public static Set<String> getAllRoles(AbstractPersonAccountEntity<? extends AbstractPositionEntity> p) {
        HashSet<String> roles = new HashSet<String>();
        if (p.getPositions() != null) {
            for (AbstractPositionEntity position : p.getPositions()) {
                Set positionRoles = Common.join((Collection[])new Collection[]{p.getRoles(), position.getRoles()});
                String domain = AbstractOrganizationAccountFactory.getDomain(position);
                boolean blankDomain = Common.isBlank((String)domain);
                for (String role : positionRoles) {
                    roles.add(role);
                    if (blankDomain || role.startsWith(domain + ".")) continue;
                    roles.add(domain + "." + role);
                }
                roles.addAll(Common.join((Collection[])new Collection[]{position.getRoles()}));
            }
        }
        return Common.join((Collection[])new Collection[]{roles, p.getRoles()});
    }

    public static String getDomain(AbstractPositionEntity position) {
        OrganizationEntity organizationEntity = position.getBelongTo();
        StringBuilder domain = new StringBuilder();
        while (organizationEntity != null) {
            String orgDomain = Common.trim((String)organizationEntity.getDomain(), (char[])new char[]{'.'});
            if (!Common.isBlank((String)orgDomain)) {
                if (domain.length() != 0) {
                    domain.append('.');
                }
                domain.append(orgDomain);
            }
            organizationEntity = Common.isBlank((String)organizationEntity.getHigherLevelId()) ? null : organizationEntity.getHigherLevel();
        }
        return domain.toString();
    }

    protected Integer[] getSupportTypes() {
        return new Integer[]{1};
    }

    public Account<ClassifiableAccountID> getAccountByID(ClassifiableAccountID id) {
        return (Account)IF.isNull((Object)this.accountSingletonMap.get((Object)id.getId()), (int)10001, (Object[])new Object[0]);
    }
}

