/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.accounts.organization.impl;

import java.util.Set;
import javax.inject.Inject;
import org.coodex.concrete.accounts.AccountsCommon;
import org.coodex.concrete.accounts.TenantAccount;
import org.coodex.concrete.accounts.organization.entities.AbstractPersonAccountEntity;
import org.coodex.concrete.accounts.organization.entities.AbstractPositionEntity;
import org.coodex.concrete.accounts.organization.entities.OrganizationEntity;
import org.coodex.concrete.accounts.organization.repositories.AbstractPersonAccountRepo;
import org.coodex.concrete.accounts.organization.repositories.OrganizationRepo;
import org.coodex.concrete.common.Account;
import org.coodex.concrete.common.ClassifiableAccountID;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.core.token.TokenWrapper;
import org.coodex.util.Common;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOrgService<J extends AbstractPositionEntity, P extends AbstractPersonAccountEntity<J>> {
    private static final Logger log = LoggerFactory.getLogger(AbstractOrgService.class);
    protected Token token = TokenWrapper.getInstance();
    @Inject
    protected OrganizationRepo organizationRepo;
    @Inject
    protected AbstractPersonAccountRepo<P> personAccountRepo;

    protected void checkManagementPermission(String orgId) {
        AbstractPersonAccountEntity person;
        ConcreteException exception = new ConcreteException(1006, new Object[0]);
        Account account = this.token.currentAccount();
        Set roles = account.getRoles();
        if (roles.contains("*")) {
            return;
        }
        if (roles.contains("SystemManager")) {
            return;
        }
        if (roles.contains("tenantManager")) {
            if (!Common.isBlank((String)orgId)) {
                OrganizationEntity organizationEntity = this.organizationRepo.findById((Object)orgId).orElse(null);
                if (Common.isSameStr((String)(organizationEntity == null ? null : organizationEntity.getTenant()), (String)AccountsCommon.getTenant())) {
                    return;
                }
            } else if (account instanceof TenantAccount) {
                TenantAccount tenantAccount = (TenantAccount)account;
                if (Common.isSameStr((String)tenantAccount.getAppSet(), (String)ConcreteHelper.getAppSet())) {
                    return;
                }
                log.info("{}(set {}) cannot use in this set: {}.", new Object[]{tenantAccount.getName(), tenantAccount.getAppSet(), ConcreteHelper.getAppSet()});
            }
        }
        if (!Common.isBlank((String)orgId) && (person = (AbstractPersonAccountEntity)this.personAccountRepo.findById((Object)((ClassifiableAccountID)account.getId()).getId()).orElse(null)) != null) {
            for (AbstractPositionEntity position : person.getPositions()) {
                if (position.getRoles() == null || !position.getRoles().contains("OrgManager")) continue;
                String positionBelongTo = position.getBelongTo().getId();
                for (OrganizationEntity organizationEntity = (OrganizationEntity)this.organizationRepo.findById((Object)orgId).orElse(null); organizationEntity != null; organizationEntity = organizationEntity.getHigherLevel()) {
                    if (!positionBelongTo.equals(organizationEntity.getId())) continue;
                    return;
                }
            }
        }
        throw exception;
    }

    protected void circleCheck(OrganizationEntity higherLevelEntity, String id) {
        for (OrganizationEntity organizationEntity = higherLevelEntity; organizationEntity != null; organizationEntity = organizationEntity.getHigherLevel()) {
            IF.is((boolean)id.equals(organizationEntity.getId()), (int)11005, (Object[])new Object[0]);
        }
    }

    protected void checkDuplication(String higherLevel, String name, String id) {
        if (id == null) {
            IF.notNull((Object)this.organizationRepo.findOneByTenantAndNameAndHigherLevelId(AccountsCommon.getTenant(), name, higherLevel), (int)11004, (Object[])new Object[0]);
        } else {
            IF.notNull((Object)this.organizationRepo.findOneByTenantAndNameAndHigherLevelIdAndIdNot(AccountsCommon.getTenant(), name, higherLevel, id), (int)11004, (Object[])new Object[0]);
        }
    }

    protected OrganizationEntity checkBelongToExists(String belongTo) {
        IF.isNull((Object)belongTo, (int)11003, (Object[])new Object[0]);
        return (OrganizationEntity)IF.isNull(this.organizationRepo.findById((Object)belongTo).orElse(null), (int)11003, (Object[])new Object[0]);
    }
}

