/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.accounts.organization.impl.copiers;

import org.coodex.concrete.accounts.AccountsCommon;
import org.coodex.concrete.accounts.organization.entities.AbstractPersonAccountEntity;
import org.coodex.concrete.accounts.organization.impl.copiers.PojoCopier;
import org.coodex.concrete.accounts.organization.pojo.Person;
import org.coodex.concrete.common.DateFormatter;
import org.coodex.util.Common;

public abstract class PersonCopier<T extends Person, E extends AbstractPersonAccountEntity>
extends PojoCopier<T, E> {
    private void setBirthday(E e, String s) {
        try {
            e.setBirthDay(((DateFormatter)AccountsCommon.DATE_FORMATTER_SERVICE_LOADER.get()).getDateFormat().format(Common.strToDate((String)s, (String)"yyyyMMdd")));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void setSex(E e, char ch) {
        try {
            e.setSex(Integer.valueOf((ch - 48) % 2 == 0 ? 2 : 1));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public E copyA2B(T t, E e) {
        e.setIdCardNo(t.getIdCardNo());
        e.setBirthDay(t.getBirthDay());
        e.setEmail(t.getEmail());
        e.setCellphone(t.getCellphone());
        e.setSex(t.getSex());
        e.setCode(t.getCode());
        if (!Common.isBlank((String)t.getIdCardNo())) {
            String idCardNo = t.getIdCardNo();
            switch (idCardNo.length()) {
                case 15: {
                    this.setBirthday(e, "19" + idCardNo.substring(6, 12));
                    this.setSex(e, idCardNo.charAt(14));
                    break;
                }
                case 18: {
                    this.setBirthday(e, idCardNo.substring(6, 14));
                    this.setSex(e, idCardNo.charAt(17));
                }
            }
        }
        return (E)((AbstractPersonAccountEntity)super.copyA2B(t, e));
    }

    public E initB(E o) {
        o.setPassword(AccountsCommon.getDefaultPassword());
        return o;
    }

    @Override
    public T copyB2A(E e, T t) {
        t.setBirthDay(e.getBirthDay());
        t.setCellphone(e.getCellphone());
        t.setCode(e.getCode());
        t.setEmail(e.getEmail());
        t.setIdCardNo(e.getIdCardNo());
        t.setSex(e.getSex());
        return (T)((Person)super.copyB2A(e, t));
    }
}

