/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client.amqp;

import org.coodex.concrete.ClientHelper;
import org.coodex.concrete.client.AbstractDestinationFactory;
import org.coodex.concrete.client.Destination;
import org.coodex.concrete.client.amqp.AMQPDestination;
import org.coodex.util.Common;

public class AMQPDestinationFactory
extends AbstractDestinationFactory<AMQPDestination> {
    private static final String AMQP = "amqp";

    static boolean isAmqp(String location) {
        if (location == null || location.length() < AMQP.length()) {
            return false;
        }
        return location.toLowerCase().startsWith(AMQP);
    }

    public Destination build(String module) {
        AMQPDestination destination = (AMQPDestination)this.init(new AMQPDestination(), module);
        destination.setHost(ClientHelper.getString((String)module, (String)"amqp.host"));
        String port = ClientHelper.getString((String)module, (String)"amqp.port");
        if (!Common.isBlank((String)port)) {
            try {
                destination.setPort(Integer.valueOf(port));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        destination.setVirtualHost(ClientHelper.getString((String)module, (String)"amqp.virtualHost"));
        destination.setUsername(ClientHelper.getString((String)module, (String)"amqp.username"));
        destination.setPassword(ClientHelper.getString((String)module, (String)"amqp.password"));
        destination.setExchangeName(ClientHelper.getString((String)module, (String)"amqp.exchange"));
        destination.setSharedExecutorName(ClientHelper.getString((String)module, (String)"amqp.executorName"));
        return destination;
    }

    public boolean accept(String module) {
        return AMQPDestinationFactory.isAmqp(this.getLocation(module));
    }
}

