/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client.amqp;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.BuiltinExchangeType;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import org.coodex.concrete.amqp.AMQPConnectionConfig;
import org.coodex.concrete.amqp.AMQPConnectionFacade;
import org.coodex.concrete.amqp.AMQPHelper;
import org.coodex.concrete.client.ClientSideContext;
import org.coodex.concrete.client.Destination;
import org.coodex.concrete.client.amqp.AMQPClientContext;
import org.coodex.concrete.client.amqp.AMQPDestination;
import org.coodex.concrete.client.impl.AbstractOwnRxInvoker;
import org.coodex.concrete.client.impl.OwnRXMessageListener;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.core.Level;
import org.coodex.concrete.own.OwnServiceUnit;
import org.coodex.concrete.own.RequestPackage;
import org.coodex.config.Config;
import org.coodex.util.Common;
import org.coodex.util.SingletonMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQPInvoker
extends AbstractOwnRxInvoker {
    private static final Logger log = LoggerFactory.getLogger(AMQPInvoker.class);
    private final Level level = Level.parse((String)((String)Config.getValue((String)"client", (Object)"DEBUG", (String[])new String[]{"amqp.logger.level", ConcreteHelper.getAppSet()})));
    private static SingletonMap<AMQPDestination, Facade> facadeSingletonMap = new SingletonMap(key -> {
        try {
            return new Facade(AMQPInvoker.getConnection(key), key.getExchangeName());
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable th) {
            throw new RuntimeException(th.getLocalizedMessage(), th);
        }
    });

    AMQPInvoker(AMQPDestination destination) {
        super((Destination)destination);
    }

    private static Connection getConnection(AMQPDestination destination) throws NoSuchAlgorithmException, KeyManagementException, URISyntaxException {
        AMQPConnectionConfig config = new AMQPConnectionConfig();
        if (destination.getLocation().length() > 7) {
            config.setUri(destination.getLocation());
        }
        config.setHost(destination.getHost());
        config.setPort(destination.getPort());
        config.setPassword(destination.getPassword());
        config.setUsername(destination.getUsername());
        config.setVirtualHost(destination.getVirtualHost());
        config.setSharedExecutorName(destination.getSharedExecutorName());
        return AMQPConnectionFacade.getConnection((AMQPConnectionConfig)config);
    }

    protected ClientSideContext getContext() {
        ServiceContext context = ConcreteContext.getServiceContext();
        if (context instanceof AMQPClientContext) {
            return (AMQPClientContext)context;
        }
        throw new RuntimeException("context [" + context + "] is NOT AMQPClientContext");
    }

    protected OwnServiceUnit findUnit(DefinitionContext context) {
        return AMQPHelper.findUnit((DefinitionContext)context);
    }

    protected Level getLoggingLevel() {
        return this.level;
    }

    protected Logger getLogger() {
        return log;
    }

    protected void send(RequestPackage requestPackage) throws Throwable {
        requestPackage.getSubjoin().put("AMQP_CLIENT_PROVIDER", "concrete-amqp-client-0.4.0-SNAPSHOT");
        ((Facade)facadeSingletonMap.get((Object)((AMQPDestination)this.getDestination()))).send(AMQPInvoker.getSerializer().toJson((Object)requestPackage));
    }

    public ServiceContext buildContext(DefinitionContext context) {
        return new AMQPClientContext(this.getDestination(), context);
    }

    private static class Facade {
        private final Channel channel;
        private final String exchangeName;
        private final String clientId = Common.getUUIDStr();

        Facade(Connection connection, String exchangeName) throws IOException {
            this.exchangeName = AMQPHelper.getExchangeName((String)exchangeName);
            this.channel = connection.createChannel();
            this.channel.exchangeDeclare(this.exchangeName, BuiltinExchangeType.TOPIC);
            String queueName = this.channel.queueDeclare().getQueue();
            this.channel.queueBind(queueName, this.exchangeName, "response." + this.clientId);
            this.channel.basicConsume(queueName, true, (Consumer)new DefaultConsumer(this.channel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) {
                    log.info("consumerTag: {}, envelope: {}", (Object)consumerTag, (Object)envelope.getRoutingKey());
                    OwnRXMessageListener.getInstance().onMessage(new String(body, StandardCharsets.UTF_8));
                }
            });
        }

        void send(String message) throws IOException {
            this.channel.basicPublish(this.exchangeName, "request." + this.clientId, null, message.getBytes(StandardCharsets.UTF_8));
        }
    }
}

