/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.amqp;

import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import java.net.URISyntaxException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutorService;
import org.coodex.concrete.amqp.AMQPConnectionConfig;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.copier.AbstractCopier;
import org.coodex.util.Common;
import org.coodex.util.SingletonMap;

public class AMQPConnectionFacade {
    private static AbstractCopier<ConnectionFactory, AMQPConnectionConfig> configCopier = new AbstractCopier<ConnectionFactory, AMQPConnectionConfig>(){

        public AMQPConnectionConfig copy(ConnectionFactory connectionFactory, AMQPConnectionConfig amqpConnectionConfig) {
            amqpConnectionConfig.setPort(connectionFactory.getPort());
            amqpConnectionConfig.setHost(connectionFactory.getHost());
            amqpConnectionConfig.setVirtualHost(connectionFactory.getVirtualHost());
            amqpConnectionConfig.setPassword(connectionFactory.getPassword());
            amqpConnectionConfig.setUsername(connectionFactory.getUsername());
            return amqpConnectionConfig;
        }
    };
    private static final String DEFAULT_SHARED_EXECUTORS_NAME = "amqp.executor";
    private static SingletonMap<String, ExecutorService> executorServiceSingletonMap = new SingletonMap<String, ExecutorService>(key -> ConcreteHelper.getExecutor((String)(Common.isBlank((String)key) ? DEFAULT_SHARED_EXECUTORS_NAME : key))){

        protected String getNullKeyOnce() {
            return AMQPConnectionFacade.DEFAULT_SHARED_EXECUTORS_NAME;
        }
    };
    private static SingletonMap<AMQPConnectionConfig, Connection> connectionSingletonMap = new SingletonMap(key -> {
        try {
            return AMQPConnectionFacade.toConnectionFactory(key).newConnection((ExecutorService)executorServiceSingletonMap.get((Object)key.getSharedExecutorName()));
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Throwable th) {
            throw new RuntimeException(th.getLocalizedMessage(), th);
        }
    });

    private static AMQPConnectionConfig clean(AMQPConnectionConfig amqpConnectionConfig) throws NoSuchAlgorithmException, KeyManagementException, URISyntaxException {
        AMQPConnectionConfig connectionConfig = (AMQPConnectionConfig)configCopier.copy((Object)AMQPConnectionFacade.toConnectionFactory(amqpConnectionConfig));
        connectionConfig.setSharedExecutorName(amqpConnectionConfig.getSharedExecutorName());
        return connectionConfig;
    }

    private static ConnectionFactory toConnectionFactory(String uri, String virtualHost, String host, Integer port, String username, String password) throws NoSuchAlgorithmException, KeyManagementException, URISyntaxException {
        ConnectionFactory connectionFactory = new ConnectionFactory();
        if (Common.isBlank((String)uri)) {
            connectionFactory.setVirtualHost(virtualHost);
            connectionFactory.setHost(host);
            if (port != null) {
                connectionFactory.setPort(port.intValue());
            }
        } else {
            connectionFactory.setUri(uri);
        }
        if (Common.isBlank((String)connectionFactory.getVirtualHost())) {
            connectionFactory.setVirtualHost("/");
        }
        if (!Common.isBlank((String)username) || !Common.isBlank((String)password)) {
            connectionFactory.setUsername(username);
            connectionFactory.setPassword(password);
        }
        connectionFactory.setAutomaticRecoveryEnabled(true);
        return connectionFactory;
    }

    private static ConnectionFactory toConnectionFactory(AMQPConnectionConfig amqpConnectionConfig) throws URISyntaxException, NoSuchAlgorithmException, KeyManagementException {
        return AMQPConnectionFacade.toConnectionFactory(amqpConnectionConfig.getUri(), amqpConnectionConfig.getVirtualHost(), amqpConnectionConfig.getHost(), amqpConnectionConfig.getPort(), amqpConnectionConfig.getUsername(), amqpConnectionConfig.getPassword());
    }

    public static Connection getConnection(AMQPConnectionConfig connectionConfig) throws NoSuchAlgorithmException, KeyManagementException, URISyntaxException {
        return (Connection)connectionSingletonMap.get((Object)AMQPConnectionFacade.clean(connectionConfig));
    }
}

