/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client.dubbo;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.rpc.RpcContext;
import org.coodex.concrete.client.ClientSideContext;
import org.coodex.concrete.client.ClientTokenManagement;
import org.coodex.concrete.client.Destination;
import org.coodex.concrete.client.dubbo.ApacheDubboClientContext;
import org.coodex.concrete.client.dubbo.ApacheDubboDestination;
import org.coodex.concrete.client.impl.AbstractSyncInvoker;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.common.Subjoin;
import org.coodex.concrete.dubbo.ApacheDubboSubjoin;
import org.coodex.concrete.dubbo.DubboConfigCaching;
import org.coodex.util.Common;
import org.coodex.util.SingletonMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApacheDubboClientInvoker
extends AbstractSyncInvoker {
    private static final Logger log = LoggerFactory.getLogger(ApacheDubboClientInvoker.class);
    private static final String CLIENT_AGENT = "concrete-apache-dubbo-client-0.4.0-SNAPSHOT";
    private static final SingletonMap<ReferenceKey, Object> REFERENCE_MAP = new SingletonMap((SingletonMap.Builder)new SingletonMap.Builder<ReferenceKey, Object>(){

        public Object build(ReferenceKey key) {
            ReferenceConfig referenceConfig = new ReferenceConfig();
            referenceConfig.setApplication(DubboConfigCaching.getApplicationConfig((String)key.dubboDestination.getName()));
            referenceConfig.setRegistries(DubboConfigCaching.getRegistries((String[])key.dubboDestination.getRegistries()));
            referenceConfig.setProtocol(key.dubboDestination.getProtocol());
            referenceConfig.setUrl(key.dubboDestination.getUrl());
            referenceConfig.setInterface(key.serviceClass);
            referenceConfig.setVersion("0.4.0-SNAPSHOT");
            return referenceConfig.get();
        }
    });

    public ApacheDubboClientInvoker(Destination destination) {
        super(destination);
    }

    protected Object execute(Class clz, Method method, Object[] args) throws Throwable {
        ApacheDubboDestination dubboDestination = (ApacheDubboDestination)this.getDestination();
        ClientSideContext context = (ClientSideContext)ConcreteContext.getServiceContext();
        String tokenId = ClientTokenManagement.getTokenId((Destination)this.getDestination(), (String)context.getTokenId());
        RpcContext rpcContext = RpcContext.getContext();
        Subjoin subjoin = context.getSubjoin();
        for (String key : subjoin.keySet()) {
            rpcContext.setAttachment(key, subjoin.get(key));
        }
        rpcContext.setAttachment("user-agent", CLIENT_AGENT);
        if (!Common.isBlank((String)tokenId)) {
            rpcContext.setAttachment("CONCRETE-TOKEN-ID", tokenId);
        }
        Object ref = REFERENCE_MAP.get((Object)new ReferenceKey(clz, dubboDestination));
        this.traceContext("before invoke:", rpcContext);
        Object result = args == null || args.length == 0 ? method.invoke(ref, new Object[0]) : method.invoke(ref, args);
        this.traceContext("after invoke:", rpcContext);
        context.responseSubjoin((Subjoin)new ApacheDubboSubjoin(rpcContext.getAttachments()));
        ClientTokenManagement.setTokenId((Destination)dubboDestination, (String)rpcContext.getAttachment("CONCRETE-TOKEN-ID"));
        return result;
    }

    private void traceContext(String label, RpcContext context) {
        if (log.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder();
            Map map = context.getAttachments();
            builder.append(map.size()).append(" context attachments");
            for (Map.Entry entry : map.entrySet()) {
                builder.append("\n\t").append((String)entry.getKey()).append(": ").append((String)entry.getValue());
            }
            log.info("{}: {}", (Object)label, (Object)builder.toString());
        }
    }

    public ServiceContext buildContext(DefinitionContext context) {
        return new ApacheDubboClientContext(this.getDestination(), context);
    }

    static class ReferenceKey {
        private Class serviceClass;
        private ApacheDubboDestination dubboDestination;

        public ReferenceKey(Class serviceClass, ApacheDubboDestination dubboDestination) {
            this.serviceClass = serviceClass;
            this.dubboDestination = dubboDestination;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ReferenceKey)) {
                return false;
            }
            ReferenceKey that = (ReferenceKey)o;
            if (!Objects.equals(this.serviceClass, that.serviceClass)) {
                return false;
            }
            return Objects.equals((Object)this.dubboDestination, (Object)that.dubboDestination);
        }

        public int hashCode() {
            int result = this.serviceClass != null ? this.serviceClass.hashCode() : 0;
            result = 31 * result + (this.dubboDestination != null ? this.dubboDestination.hashCode() : 0);
            return result;
        }
    }
}

