/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools.jaxrs;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.StringTokenizer;
import org.coodex.concrete.api.Description;
import org.coodex.concrete.apitools.jaxrs.AbstractRender;
import org.coodex.concrete.apitools.jaxrs.POJOTypeInfo;
import org.coodex.concrete.jaxrs.JaxRSHelper;
import org.coodex.util.Common;

public abstract class DocToolkit {
    private AbstractRender render;

    public static boolean isPojo(Class<?> type) {
        return !JaxRSHelper.isPrimitive(type) && !type.isArray() && !Collection.class.isAssignableFrom(type) && !Map.class.isAssignableFrom(type);
    }

    public DocToolkit(AbstractRender render) {
        this.render = render;
    }

    public String canonicalName(String name) {
        return this.canonicalName(name, "\\/");
    }

    public String canonicalName(String name, String delim) {
        StringBuilder builder = new StringBuilder();
        StringTokenizer stringTokenizer = new StringTokenizer(name, delim);
        while (stringTokenizer.hasMoreTokens()) {
            String s = stringTokenizer.nextToken();
            if (Common.isBlank((String)s)) continue;
            if (builder.length() > 0) {
                builder.append("_");
            }
            builder.append(s);
        }
        return builder.toString();
    }

    public String formatTypeStr(Type t, Class<?> contextClass) {
        return this.formatPOJOTypeInfo(new POJOTypeInfo(contextClass, t));
    }

    public String formatPOJOTypeInfo(POJOTypeInfo info) {
        if (info.getType() == null) {
            return info.getGenericType().toString();
        }
        if (info.getType().isArray()) {
            return this.formatPOJOTypeInfo(info.getArrayElement()) + "[]";
        }
        StringBuilder builder = new StringBuilder(this.getTypeName(info.getType()));
        if (info.getGenericParameters().size() > 0) {
            builder.append("<");
            boolean isFirst = true;
            for (POJOTypeInfo param : info.getGenericParameters()) {
                if (!isFirst) {
                    builder.append(", ");
                }
                builder.append(this.formatPOJOTypeInfo(param));
                if (!isFirst) continue;
                isFirst = false;
            }
            builder.append(">");
        }
        return builder.toString();
    }

    protected abstract String getTypeName(Class<?> var1);

    public AbstractRender getRender() {
        return this.render;
    }

    public String camelCase(String str) {
        return JaxRSHelper.camelCase((String)str);
    }

    public String tableSafe(String str) {
        return Common.isBlank((String)str) ? "\u3000" : str;
    }

    public String tableSafeDesc(Description description) {
        return description == null ? "\u3000" : this.tableSafe(description.description());
    }

    public String tableSafeLabel(Description description) {
        return description == null ? "\u3000" : this.tableSafe(description.name());
    }
}

