/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools.jaxrs;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.coodex.concrete.api.Description;
import org.coodex.concrete.apitools.jaxrs.POJOTypeInfo;
import org.coodex.concrete.jaxrs.JaxRSHelper;

public class POJOPropertyInfo {
    private final String name;
    private final Description description;
    private POJOTypeInfo pojoTypeInfo;

    public POJOPropertyInfo(Class<?> contextType, Method method) {
        String methodName = method.getName();
        int startIndex = methodName.startsWith("is") && method.getReturnType() == Boolean.TYPE ? 2 : 3;
        this.name = JaxRSHelper.lowerFirstChar((String)method.getName().substring(startIndex));
        this.pojoTypeInfo = new POJOTypeInfo(contextType, method.getGenericReturnType());
        this.description = method.getAnnotation(Description.class);
    }

    public POJOPropertyInfo(Class<?> contextType, Field field) {
        this.name = field.getName();
        this.description = field.getAnnotation(Description.class);
        this.pojoTypeInfo = new POJOTypeInfo(contextType, field.getGenericType());
    }

    public String getName() {
        return this.name;
    }

    public POJOTypeInfo getType() {
        return this.pojoTypeInfo;
    }

    public String getLabel() {
        return this.description == null ? "" : this.description.name();
    }

    public String getDescription() {
        return this.description == null ? "" : this.description.description();
    }
}

