/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools.jaxrs.service;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.coodex.concrete.apitools.jaxrs.AbstractRender;
import org.coodex.concrete.apitools.jaxrs.DocToolkit;
import org.coodex.concrete.apitools.jaxrs.POJOPropertyInfo;
import org.coodex.util.ReflectHelper;

public class ServiceDocToolkit
extends DocToolkit {
    private Set<String> pojoTypes = new HashSet<String>();

    public ServiceDocToolkit(AbstractRender render) {
        super(render);
    }

    public Set<String> getPojos() {
        return this.pojoTypes;
    }

    @Override
    protected String getTypeName(Class<?> clz) {
        try {
            return ServiceDocToolkit.isPojo(clz) ? this.build(clz) : clz.getSimpleName();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String build(Class<?> clz) throws IOException {
        if (!this.pojoTypes.contains(clz)) {
            ArrayList<POJOPropertyInfo> pojoPropertyInfos = new ArrayList<POJOPropertyInfo>();
            for (Method method : clz.getMethods()) {
                if (!this.isProperty(method)) continue;
                pojoPropertyInfos.add(new POJOPropertyInfo(clz, method));
            }
            for (AccessibleObject accessibleObject : ReflectHelper.getAllDeclaredFields(clz)) {
                if (!this.isProperty((Field)accessibleObject)) continue;
                pojoPropertyInfos.add(new POJOPropertyInfo(clz, (Field)accessibleObject));
            }
            this.pojoTypes.add(this.canonicalName(clz.getName()));
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("properties", pojoPropertyInfos);
            map.put("type", clz.getName());
            map.put("tool", this);
            this.getRender().writeTo("pojos/" + this.canonicalName(clz.getName()) + ".md", "pojo.md", map);
        }
        StringBuilder builder = new StringBuilder("[");
        builder.append(clz.getSimpleName()).append("](../pojos/").append(this.canonicalName(clz.getName())).append(".md)");
        return builder.toString();
    }

    private boolean isProperty(Field field) {
        int mod = field.getModifiers();
        return Modifier.isPublic(mod) && !Modifier.isStatic(mod) && !Modifier.isTransient(mod);
    }

    private boolean isProperty(Method method) {
        String name = method.getName();
        return method.getDeclaringClass() != Object.class && Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers()) && !Modifier.isTransient(method.getModifiers()) && (name.startsWith("get") || name.startsWith("is") && method.getReturnType() == Boolean.TYPE);
    }
}

