/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools.rx;

import java.io.IOException;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.coodex.concrete.apitools.AbstractRender;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.jaxrs.struct.Module;
import org.coodex.concrete.jaxrs.struct.Param;
import org.coodex.concrete.jaxrs.struct.Unit;
import org.coodex.util.TypeHelper;

public class ReactiveStreamsRender
extends AbstractRender {
    public static final String RENDER_NAME = "java.code.RxJava2.v1";

    @Override
    protected String getTemplatePath() {
        return "concrete/templates/rx/java/code/v1/";
    }

    @Override
    protected String getRenderName() {
        return RENDER_NAME;
    }

    @Override
    public void writeTo(String ... packages) throws IOException {
        List modules = ConcreteHelper.loadModules((String)"JaxRS.loader", (String[])packages);
        for (Module module : modules) {
            HashMap<String, Object> toWrite = new HashMap<String, Object>();
            HashSet<String> imports = new HashSet<String>();
            toWrite.put("imports", imports);
            Class clazz = module.getInterfaceClass();
            imports.add(clazz.getName());
            String packageName = "rx." + clazz.getPackage().getName();
            String rxClassName = clazz.getSimpleName() + "_RX";
            String outputPath = packageName.replace('.', '/') + '/' + rxClassName + ".java";
            toWrite.put("package", "rx." + clazz.getPackage().getName());
            toWrite.put("concreteClassName", clazz.getSimpleName());
            toWrite.put("rxClassName", rxClassName);
            HashSet<MethodInfo> methods = new HashSet<MethodInfo>();
            toWrite.put("methods", methods);
            for (Unit unit : (Unit[])module.getUnits()) {
                methods.add(this.unitToMethod(unit, imports));
            }
            this.writeTo(outputPath, "rx.java.ftl", toWrite);
        }
    }

    private void addTo(Set<String> imports, String className) {
        try {
            Class<?> c = Class.forName(className);
            if (!c.isPrimitive() && !c.getPackage().getName().equals("java.lang")) {
                imports.add(className);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private String typeToStr(Type t, Type context, Set<String> imports, boolean autoBox) {
        if ((t = TypeHelper.toTypeReference((Type)t, (Type[])new Type[]{context})) instanceof Class) {
            return this.classToStr((Class)t, imports, autoBox);
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)t;
            StringBuilder builder = new StringBuilder();
            builder.append(this.classToStr((Class)pt.getRawType(), imports, false));
            Type[] parameters = pt.getActualTypeArguments();
            builder.append("<");
            int len = parameters.length;
            for (int i = 0; i < len; ++i) {
                if (i != 0) {
                    builder.append(", ");
                }
                builder.append(this.typeToStr(parameters[i], context, imports, false));
            }
            return builder.append(">").toString();
        }
        if (t instanceof GenericArrayType) {
            return this.typeToStr(((GenericArrayType)t).getGenericComponentType(), context, imports, false) + "[]";
        }
        throw new RuntimeException("unknown TYPE: " + t);
    }

    private String classToStr(Class c, Set<String> imports, boolean autoBox) {
        if (c.isArray()) {
            return this.classToStr(c.getComponentType(), imports, false) + "[]";
        }
        if (Void.TYPE.equals(c)) {
            return "Void";
        }
        if (autoBox && c.isPrimitive()) {
            return this.autoBox(c);
        }
        String className = c.getName();
        this.addTo(imports, className);
        return c.getSimpleName();
    }

    private String autoBox(Class c) {
        if (Byte.TYPE.equals(c)) {
            return Byte.class.getSimpleName();
        }
        if (Short.TYPE.equals(c)) {
            return Short.class.getSimpleName();
        }
        if (Integer.TYPE.equals(c)) {
            return Integer.class.getSimpleName();
        }
        if (Character.TYPE.equals(c)) {
            return Character.class.getSimpleName();
        }
        if (Long.TYPE.equals(c)) {
            return Long.class.getSimpleName();
        }
        if (Boolean.TYPE.equals(c)) {
            return Boolean.class.getSimpleName();
        }
        if (Float.TYPE.equals(c)) {
            return Float.class.getSimpleName();
        }
        if (Double.TYPE.equals(c)) {
            return Double.class.getSimpleName();
        }
        return null;
    }

    private MethodInfo unitToMethod(Unit unit, Set<String> imports) {
        MethodInfo methodInfo = new MethodInfo();
        methodInfo.setName(unit.getFunctionName());
        Class context = ((Module)unit.getDeclaringModule()).getInterfaceClass();
        methodInfo.setReturnType(this.typeToStr(unit.getGenericReturnType(), context, imports, true));
        for (Param param : (Param[])unit.getParameters()) {
            ParamInfo paramInfo = new ParamInfo();
            paramInfo.setName(param.getName());
            paramInfo.setType(this.typeToStr(param.getGenericType(), context, imports, false));
            methodInfo.getParams().add(paramInfo);
        }
        return methodInfo;
    }

    public static void main(String[] args) {
        System.out.println(Integer.TYPE.getSimpleName());
    }

    public static class ParamInfo {
        private String type;
        private String name;

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class MethodInfo {
        private String name;
        private String returnType;
        private List<ParamInfo> params = new ArrayList<ParamInfo>();

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public void setReturnType(String returnType) {
            this.returnType = returnType;
        }

        public List<ParamInfo> getParams() {
            return this.params;
        }
    }
}

