/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.coodex.concrete.api.ConcreteService;
import org.coodex.concrete.apitools.AbstractRender;
import org.coodex.concrete.apitools.jaxrs.angular.meta.TSClass;
import org.coodex.concrete.apitools.jaxrs.angular.meta.TSField;
import org.coodex.concrete.apitools.jaxrs.angular.meta.TSImport;
import org.coodex.concrete.apitools.jaxrs.angular.meta.TSMethod;
import org.coodex.concrete.apitools.jaxrs.angular.meta.TSModule;
import org.coodex.concrete.apitools.jaxrs.angular.meta.TSParam;
import org.coodex.concrete.apitools.jaxrs.angular.meta.TSPojo;
import org.coodex.concrete.common.struct.AbstractModule;
import org.coodex.concrete.common.struct.AbstractParam;
import org.coodex.concrete.common.struct.AbstractUnit;
import org.coodex.util.Common;
import org.coodex.util.TypeHelper;

public abstract class AbstractAngularRender<U extends AbstractUnit>
extends AbstractRender {
    protected static final ThreadLocal<Map<String, Map<Class, TSClass>>> CLASSES = new ThreadLocal();
    private static final Class[] NUMBERS = new Class[]{Byte.TYPE, Integer.TYPE, Short.TYPE, Long.TYPE, Float.TYPE, Double.TYPE};

    protected String getMethodName(String name, Set<String> methods) {
        String methodName = name;
        int prefix = 0;
        while (methods.contains(methodName)) {
            methodName = name + prefix++;
        }
        methods.add(methodName);
        return methodName;
    }

    protected abstract String getModuleType();

    private Map<String, Map<Class, TSClass>> getClasses() {
        return CLASSES.get();
    }

    protected String getModuleName(String moduleName) {
        return moduleName.charAt(0) == '@' ? moduleName : "@" + moduleName;
    }

    private String getContextPath(String key) {
        StringBuilder builder = new StringBuilder();
        for (char ch : key.toCharArray()) {
            if (ch != '/') continue;
            builder.append("../");
        }
        return builder.toString();
    }

    protected void packages(String contextPath) throws IOException {
        HashMap services = new HashMap();
        HashSet<String> providers = new HashSet<String>();
        HashSet<String> packages = new HashSet<String>();
        for (String key : this.getClasses().keySet()) {
            packages.add(key);
            Map<Class, TSClass> map = this.getClasses().get(key);
            HashMap<String, Object> toWrite = new HashMap<String, Object>();
            toWrite.put("contextPath", this.getContextPath(key));
            HashSet<Class> classSet = new HashSet<Class>();
            for (Class clz : map.keySet()) {
                if (ConcreteService.class.isAssignableFrom(clz)) {
                    toWrite.put("includeServices", Boolean.TRUE);
                    providers.add(map.get(clz).getClassName());
                    Set<String> set = services.containsKey(key) ? (Set)services.get(key) : new HashSet();
                    set.add(map.get(clz).getClassName());
                    services.put(key, set);
                }
                classSet.addAll(map.get(clz).getImports());
            }
            HashMap<String, TSImport> imports = new HashMap<String, TSImport>();
            for (Class clz : classSet) {
                String packageName = this.getPackageKey(clz);
                if (key.equals(packageName)) continue;
                TSImport importSet = (TSImport)imports.get(packageName);
                if (importSet == null) {
                    importSet = new TSImport();
                    importSet.setPackageName(packageName);
                    imports.put(packageName, importSet);
                }
                importSet.getClasses().add(clz.getSimpleName());
            }
            toWrite.put("imports", imports.values());
            toWrite.put("classes", this.sort(map));
            this.writeTo(contextPath + key + ".ts", "tspackage.ftl", toWrite);
        }
        HashMap<String, Object> toWrite = new HashMap<String, Object>();
        toWrite.put("services", services);
        toWrite.put("providers", providers);
        toWrite.put("packages", packages);
        toWrite.put("moduleType", this.getModuleType());
        this.writeTo(contextPath + "Concrete" + this.getModuleType() + "Module.ts", "concrete.ftl", toWrite);
    }

    private String getPackageKey(Class clz) {
        return clz.getPackage().getName().replace('.', '/');
    }

    private Collection<TSClass> sort(Map<Class, TSClass> classes) {
        ArrayList<TSClass> ordered = new ArrayList<TSClass>();
        HashMap<Class, TSClass> cache = new HashMap<Class, TSClass>(classes);
        while (cache.keySet().size() > 0) {
            Class[] keys;
            for (Class key : keys = cache.keySet().toArray(new Class[0])) {
                TSClass tsClass = (TSClass)cache.get(key);
                if (!this.noDep(tsClass, cache)) continue;
                cache.remove(key);
                ordered.add(tsClass);
            }
        }
        return ordered;
    }

    private boolean noDep(TSClass tsClass, Map<Class, TSClass> cache) {
        if (tsClass instanceof TSPojo) {
            return cache.get(((TSPojo)tsClass).getSuperType()) == null;
        }
        for (Class clz : tsClass.getImports()) {
            if (cache.get(clz) == null) continue;
            return false;
        }
        return true;
    }

    protected void process(String moduleName, AbstractModule<U> module) {
        Class clz = module.getInterfaceClass();
        Map<Class, TSClass> moduleMap = this.getTSClassMap(clz);
        if (moduleMap == null) {
            return;
        }
        TSModule tsModule = new TSModule(clz);
        tsModule.setBelong(moduleName);
        HashSet<String> methods = new HashSet<String>();
        for (AbstractUnit unit : module.getUnits()) {
            TSMethod method = new TSMethod();
            method.setName(this.getMethodName(unit.getMethod().getName(), methods));
            method.setHttpMethod(unit.getInvokeType());
            method.setReturnType(this.getClassType(unit.getGenericReturnType(), tsModule, clz));
            method.setMethodPath(this.getMethodPath(module, unit));
            method.setBody(this.getBody(unit));
            method.setParams(this.getParams(unit, tsModule));
            tsModule.getMethods().add(method);
        }
        moduleMap.put(clz, tsModule);
    }

    protected abstract String getMethodPath(AbstractModule<U> var1, U var2);

    private List<TSParam> getParams(U unit, TSClass clz) {
        ArrayList<TSParam> fieldList = new ArrayList<TSParam>();
        for (int i = 0; i < unit.getParameters().length; ++i) {
            AbstractParam param = unit.getParameters()[i];
            TSParam field = new TSParam();
            field.setName(param.getName());
            field.setType(this.getClassType(param.getGenericType(), clz, unit.getDeclaringModule().getInterfaceClass()));
            fieldList.add(field);
        }
        return fieldList;
    }

    private Map<Class, TSClass> getTSClassMap(Class<?> clz) {
        String packageName;
        Map<String, Map<Class, TSClass>> classes = this.getClasses();
        Map<Class, TSClass> moduleMap = classes.get(packageName = clz.getPackage().getName().replace('.', '/'));
        if (moduleMap == null) {
            moduleMap = new HashMap<Class, TSClass>();
            classes.put(packageName, moduleMap);
        }
        return moduleMap;
    }

    private String getClassType(Type type, TSClass clz, Class contextClass) {
        if (type instanceof Class) {
            Class c = (Class)type;
            if (c.isArray()) {
                return this.getClassType(c.getComponentType(), clz, contextClass) + "[]";
            }
            return this.getClassType((Class)type, clz);
        }
        if (type instanceof ParameterizedType) {
            return this.getParameterizedType(clz, (ParameterizedType)type, contextClass);
        }
        if (type instanceof GenericArrayType) {
            return this.getClassType(((GenericArrayType)type).getGenericComponentType(), clz, contextClass) + "[]";
        }
        if (type instanceof TypeVariable) {
            if (contextClass != null) {
                return this.getClassType(TypeHelper.solve((TypeVariable)((TypeVariable)type), (Type[])new Type[]{contextClass}), clz, null);
            }
            return ((TypeVariable)type).getName();
        }
        throw new RuntimeException("unknown type: " + type);
    }

    private String getParameterizedType(TSClass clz, ParameterizedType pt, Class contextClass) {
        Class rawType = (Class)pt.getRawType();
        if (Collection.class.isAssignableFrom(rawType)) {
            return this.getClassType(pt.getActualTypeArguments()[0], clz, contextClass) + "[]";
        }
        if (Map.class.isAssignableFrom(rawType)) {
            return String.format("Map<%s, %s>", this.getClassType(pt.getActualTypeArguments()[0], clz, contextClass), this.getClassType(pt.getActualTypeArguments()[1], clz, contextClass));
        }
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClassType(rawType, clz)).append("<");
        boolean isFirst = true;
        for (Type t : pt.getActualTypeArguments()) {
            if (!isFirst) {
                builder.append(", ");
            }
            builder.append(this.getClassType(t, clz, contextClass));
            isFirst = false;
        }
        builder.append(">");
        return builder.toString();
    }

    private String getClassType(Class c, TSClass clz) {
        if (Void.TYPE.equals(c) || Void.class.equals((Object)c)) {
            return "void";
        }
        if (Boolean.TYPE.equals(c) || Boolean.class.equals((Object)c)) {
            return "boolean";
        }
        if (Common.inArray((Object)c, (Object[])NUMBERS) || Number.class.isAssignableFrom(c)) {
            return "number";
        }
        if (Character.TYPE.equals(c) || Character.class.equals((Object)c) || CharSequence.class.isAssignableFrom(c)) {
            return "string";
        }
        if (Collection.class.isAssignableFrom(c)) {
            return "any[]";
        }
        if (Map.class.isAssignableFrom(c)) {
            return "Map<any, any>";
        }
        if (Object.class.equals((Object)c)) {
            return "any";
        }
        clz.getImports().add(c);
        return this.getTSPojo(c).getClassName();
    }

    private TSPojo getTSPojo(Class c) {
        Map<Class, TSClass> map = this.getTSClassMap(c);
        if (map.containsKey(c)) {
            return (TSPojo)map.get(c);
        }
        TSPojo pojo = new TSPojo(c);
        map.put(c, pojo);
        if (Object.class.equals((Object)c)) {
            return pojo;
        }
        if (!Object.class.equals((Object)c.getGenericSuperclass())) {
            pojo.setSuperClass(this.getClassType(c.getGenericSuperclass(), pojo, null));
        }
        for (Field field : c.getDeclaredFields()) {
            int mod = field.getModifiers();
            if (Modifier.isStatic(mod) || Modifier.isTransient(mod)) continue;
            TSField tsField = new TSField();
            tsField.setName(field.getName());
            tsField.setType(this.getClassType(field.getGenericType(), pojo, null));
            pojo.getFields().add(tsField);
        }
        while (!Object.class.equals(c.getSuperclass())) {
            c = c.getSuperclass();
            this.getTSPojo(c);
        }
        return pojo;
    }

    protected abstract String getBody(U var1);
}

