/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools;

import java.io.IOException;
import java.util.Iterator;
import org.coodex.concrete.apitools.ConcreteAPIRender;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ConcreteServiceLoader;
import org.coodex.util.ServiceLoader;

public class API {
    private static final ServiceLoader<ConcreteAPIRender> RENDERS = new ConcreteServiceLoader<ConcreteAPIRender>(){};
    private static final String TAG_API_GENERATOR = "api_gen";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generate(String desc, String path, String ... packages) throws IOException {
        if (packages == null) {
            packages = ConcreteHelper.getApiPackages();
        }
        if (RENDERS.getAllInstances().size() == 0) {
            throw new RuntimeException("NONE render found.");
        }
        Iterator iterator = RENDERS.getAllInstances().iterator();
        while (iterator.hasNext()) {
            ConcreteAPIRender render;
            ConcreteAPIRender concreteAPIRender = render = (ConcreteAPIRender)iterator.next();
            synchronized (concreteAPIRender) {
                if (render.isAccept(desc)) {
                    render.setRoot(path);
                    render.writeTo(packages);
                    return;
                }
            }
        }
        throw new RuntimeException("NONE render for " + desc + " found.");
    }

    public static void generateFor(String module, String ... packages) throws IOException {
        String desc = ConcreteHelper.getString((String)TAG_API_GENERATOR, (String)module, (String)"desc");
        String path = ConcreteHelper.getString((String)TAG_API_GENERATOR, (String)module, (String)"path");
        API.generate(desc, path, packages);
    }
}

