/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools.jaxrs;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import org.coodex.util.TypeHelper;

public class POJOTypeInfo {
    private static final Class<?> ARRAY_CLASS = new Object[0].getClass();
    private static final POJOTypeInfo OBJECT_POJO_INFO = new POJOTypeInfo(Object.class, (Type)((Object)Object.class));
    private final Class<?> contextType;
    private final Type genericType;
    private final Class<?> type;
    private POJOTypeInfo arrayElement = OBJECT_POJO_INFO;
    private List<POJOTypeInfo> genericParameters = new ArrayList<POJOTypeInfo>();

    public POJOTypeInfo(Class<?> contextType, Type genericType) {
        this.contextType = contextType;
        this.genericType = genericType;
        this.type = this.loadClass();
    }

    public Class<?> getContextType() {
        return this.contextType;
    }

    private Class<?> loadClass() {
        return this.$loadClass(this.genericType);
    }

    private Class<?> $loadClass(Type genericType) {
        if (genericType instanceof GenericArrayType) {
            this.arrayElement = new POJOTypeInfo(this.contextType, ((GenericArrayType)genericType).getGenericComponentType());
            return ARRAY_CLASS;
        }
        if (genericType instanceof ParameterizedType) {
            Class clz = (Class)((ParameterizedType)genericType).getRawType();
            for (Type t : ((ParameterizedType)genericType).getActualTypeArguments()) {
                this.genericParameters.add(new POJOTypeInfo(this.contextType, t));
            }
            return clz;
        }
        if (genericType instanceof Class) {
            if (((Class)genericType).isArray()) {
                this.arrayElement = new POJOTypeInfo(this.contextType, ((Class)genericType).getComponentType());
                return ARRAY_CLASS;
            }
            return (Class)genericType;
        }
        if (genericType instanceof TypeVariable) {
            return this.$loadClass(TypeHelper.solve((TypeVariable)((TypeVariable)genericType), (Type[])new Type[]{this.contextType}));
        }
        throw new RuntimeException("unknown Type: " + genericType + ". genericType: " + this.genericType + ": instanceClass:" + this.contextType);
    }

    public Type getGenericType() {
        return this.genericType;
    }

    public Class<?> getType() {
        return this.type;
    }

    public POJOTypeInfo getArrayElement() {
        return this.arrayElement;
    }

    public List<POJOTypeInfo> getGenericParameters() {
        return this.genericParameters;
    }
}

