/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools.jaxrs.service;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.coodex.concrete.apitools.AbstractRender;
import org.coodex.concrete.apitools.jaxrs.DocToolkit;
import org.coodex.concrete.apitools.jaxrs.POJOPropertyInfo;
import org.coodex.util.PojoInfo;
import org.coodex.util.PojoProperty;
import org.coodex.util.TypeHelper;

public class ServiceDocToolkit
extends DocToolkit {
    private Set<String> pojoTypes = new HashSet<String>();

    public ServiceDocToolkit(AbstractRender render) {
        super(render);
    }

    @Override
    protected String getClassLabel(Class<?> clz) throws IOException {
        if (TypeHelper.isPrimitive(clz) || clz.getPackage().getName().startsWith("java")) {
            return clz.getSimpleName();
        }
        this.buildPojo(clz);
        StringBuilder builder = new StringBuilder("[");
        builder.append(clz.getSimpleName()).append("](../pojos/").append(this.canonicalName(clz.getName())).append(".md)");
        return builder.toString();
    }

    private void buildPojo(Class<?> clz) throws IOException {
        String name = this.canonicalName(clz.getName());
        if (!this.pojoTypes.contains(name)) {
            this.pojoTypes.add(name);
            ArrayList<POJOPropertyInfo> pojoPropertyInfos = new ArrayList<POJOPropertyInfo>();
            PojoInfo pojoInfo = new PojoInfo(clz, new Type[0]);
            for (PojoProperty pojoProperty : pojoInfo.getProperties()) {
                pojoPropertyInfos.add(new POJOPropertyInfo(pojoProperty));
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("properties", pojoPropertyInfos);
            map.put("type", clz.getName());
            map.put("tool", this);
            this.getRender().writeTo("pojos/" + this.canonicalName(clz.getName()) + ".md", "pojo.md", map);
        }
    }

    public Set<String> getPojos() {
        return this.pojoTypes;
    }

    private boolean isProperty(Field field) {
        int mod = field.getModifiers();
        return Modifier.isPublic(mod) && !Modifier.isStatic(mod) && !Modifier.isTransient(mod);
    }

    private boolean isProperty(Method method) {
        String name = method.getName();
        return method.getDeclaringClass() != Object.class && Modifier.isPublic(method.getModifiers()) && !Modifier.isStatic(method.getModifiers()) && !Modifier.isTransient(method.getModifiers()) && (name.startsWith("get") || name.startsWith("is") && method.getReturnType() == Boolean.TYPE);
    }
}

