/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.modules.AbstractModule;
import org.coodex.concrete.common.modules.ModuleMaker;
import org.coodex.util.AcceptableServiceLoader;

public class APIHelper {
    private static final AcceptableServiceLoader<String, ModuleMaker<?>> MODULE_MAKERS = new AcceptableServiceLoader<String, ModuleMaker<?>>(){};

    private static ModuleMaker getInstance(String desc) {
        ModuleMaker moduleMaker = (ModuleMaker)MODULE_MAKERS.select((Object)desc);
        if (moduleMaker == null) {
            throw new RuntimeException("No module maker supported '" + desc + "' ");
        }
        return moduleMaker;
    }

    public static final <MODULE extends AbstractModule> List<MODULE> loadModules(String desc, String ... packages) {
        return APIHelper.loadModules(APIHelper.getInstance(desc), packages);
    }

    private static <MODULE extends AbstractModule> List<MODULE> loadModules(ModuleMaker<MODULE> maker, String ... packages) {
        HashMap moduleMap = new HashMap();
        ConcreteHelper.foreachClassInPackages(serviceClass -> {
            if (ConcreteHelper.isConcreteService((Class)serviceClass)) {
                AbstractModule module = maker.make(serviceClass);
                Class key = module.getInterfaceClass();
                AbstractModule exists = (AbstractModule)moduleMap.get(key);
                if (exists != null) {
                    throw new RuntimeException(String.format("Module %s duplicated. %s & %s", key, exists.getInterfaceClass().getName(), module.getInterfaceClass().getName()));
                }
                moduleMap.put(key, module);
            }
        }, (String[])packages);
        ArrayList moduleList = new ArrayList(moduleMap.values());
        Collections.sort(moduleList);
        return moduleList;
    }
}

