/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.coodex.concrete.apitools.ConcreteAPIRender;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.util.ServiceLoader;
import org.coodex.util.ServiceLoaderImpl;

public class API {
    private static final ServiceLoader<ConcreteAPIRender> RENDERS = new ServiceLoaderImpl<ConcreteAPIRender>(){};
    private static final String TAG_API_GENERATOR = "api_gen";

    public static void generate(String desc, String path, String ... packages) throws IOException {
        API.generate(null, desc, path, packages);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generate(Map<String, Object> ext, String desc, String path, String ... packages) throws IOException {
        if (packages == null) {
            packages = ConcreteHelper.getApiPackages();
        }
        if (RENDERS.getAll().size() == 0) {
            throw new RuntimeException("NONE render found.");
        }
        Iterator iterator = RENDERS.getAll().values().iterator();
        while (iterator.hasNext()) {
            ConcreteAPIRender render;
            ConcreteAPIRender concreteAPIRender = render = (ConcreteAPIRender)iterator.next();
            synchronized (concreteAPIRender) {
                if (render.isAccept(desc)) {
                    render.setRoot(path);
                    render.setExt(ext);
                    render.writeTo(packages);
                    return;
                }
            }
        }
        throw new RuntimeException("NONE render for " + desc + " found.");
    }

    public static void generateFor(String module, String ... packages) throws IOException {
        String desc = ConcreteHelper.getString((String)TAG_API_GENERATOR, (String)module, (String)"desc");
        String path = ConcreteHelper.getString((String)TAG_API_GENERATOR, (String)module, (String)"path");
        API.generate(API.toMap(ConcreteHelper.getString((String)TAG_API_GENERATOR, (String)module, (String)"ext")), desc, path, packages);
    }

    private static Map<String, Object> toMap(String json) {
        if (json == null) {
            return new HashMap<String, Object>();
        }
        return (Map)JSON.parseObject((String)json, (TypeReference)new TypeReference<Map<String, Object>>(){}, (Feature[])new Feature[0]);
    }
}

