/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools.websocket.jquery;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.coodex.concrete.apitools.APIHelper;
import org.coodex.concrete.apitools.AbstractRender;
import org.coodex.concrete.common.modules.AbstractParam;
import org.coodex.concrete.websocket.WebSocketModule;
import org.coodex.concrete.websocket.WebSocketUnit;
import org.coodex.util.Common;

public class JQueryWebSocketCodeRender
extends AbstractRender {
    public static final String RENDER_NAME = "WebSocket.code.jquery.js.v1";
    private static final String RESOURCE_PACKAGE = "concrete/templates/websocket/jquery/code/v1/";

    @Override
    protected String getTemplatePath() {
        return RESOURCE_PACKAGE;
    }

    @Override
    protected String getRenderName() {
        return RENDER_NAME;
    }

    private String buildMethod(WebSocketUnit unit) {
        StringBuilder builder = new StringBuilder();
        StringBuilder parameters = new StringBuilder();
        builder.append("function (");
        switch (unit.getParameters().length) {
            case 0: {
                parameters.append("undefined");
                break;
            }
            case 1: {
                builder.append(unit.getParameters()[0].getName());
                parameters.append(unit.getParameters()[0].getName());
                break;
            }
            default: {
                parameters.append("{");
                for (int i = 0; i < unit.getParameters().length; ++i) {
                    AbstractParam param = unit.getParameters()[i];
                    if (i > 0) {
                        builder.append(", ");
                        parameters.append(", ");
                    }
                    String n = param.getName();
                    builder.append(n);
                    parameters.append("\"").append(n).append("\": ").append(n);
                }
                parameters.append("}");
            }
        }
        builder.append(") {return invoke({\"serviceId\": \"").append(unit.getKey()).append("\",\"param\": ").append(parameters.toString()).append(" });}");
        return builder.toString();
    }

    private String overload(WebSocketModule module) {
        HashMap<String, HashSet<WebSocketUnit>> methods = new HashMap<String, HashSet<WebSocketUnit>>();
        for (WebSocketUnit unit : (WebSocketUnit[])module.getUnits()) {
            String key = unit.getMethod().getName();
            HashSet<WebSocketUnit> units = (HashSet<WebSocketUnit>)methods.get(key);
            if (units == null) {
                units = new HashSet<WebSocketUnit>();
                methods.put(key, units);
            }
            units.add(unit);
        }
        StringBuilder builder = new StringBuilder();
        for (String methodName : methods.keySet()) {
            if (builder.length() > 0) {
                builder.append(", ");
            }
            builder.append("\"").append(methodName).append("\": ");
            WebSocketUnit[] units = ((Set)methods.get(methodName)).toArray(new WebSocketUnit[0]);
            if (units.length > 1) {
                builder.append("overload(\"").append(methodName).append("\", {");
                for (int i = 0; i < units.length; ++i) {
                    if (i > 0) {
                        builder.append(", ");
                    }
                    builder.append("\"").append(units[i].getParameters().length).append("\": ").append(this.buildMethod(units[i]));
                }
                builder.append("})");
                continue;
            }
            builder.append(this.buildMethod(units[0]));
        }
        return builder.toString();
    }

    @Override
    public void writeTo(String ... packages) throws IOException {
        List<WebSocketModule> moduleList = APIHelper.loadModules(RENDER_NAME, packages);
        HashSet<String> modules = new HashSet<String>();
        for (WebSocketModule module : moduleList) {
            StringBuilder builder = new StringBuilder();
            builder.append("register(\"").append(module.getInterfaceClass().getSimpleName()).append("\", \"").append(module.getInterfaceClass().getPackage().getName()).append("\", { ").append(this.overload(module)).append("});");
            modules.add(builder.toString());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("modules", modules);
        String moduleName = this.getRenderDesc().substring(RENDER_NAME.length());
        moduleName = Common.isBlank((String)moduleName) ? "concrete" : moduleName.substring(1);
        map.put("moduleName", moduleName);
        this.writeTo("jquery-websocket-concrete.js", "jquery-websocket-concrete.js.ftl", map);
    }
}

