/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apitools.websocket.angular;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.coodex.concrete.apitools.APIHelper;
import org.coodex.concrete.apitools.AbstractAngularRender;
import org.coodex.concrete.common.modules.AbstractModule;
import org.coodex.concrete.common.modules.AbstractParam;
import org.coodex.concrete.websocket.WebSocketModule;
import org.coodex.concrete.websocket.WebSocketUnit;
import org.coodex.util.Common;

public class AngularWebSocketCodeRender
extends AbstractAngularRender<WebSocketUnit> {
    public static final String RENDER_NAME = "WebSocket.code.angular.ts.v1";
    private static final String RESOURCE_PACKAGE = "concrete/templates/websocket/angular/code/v1/";

    @Override
    protected String getTemplatePath() {
        return RESOURCE_PACKAGE;
    }

    @Override
    protected String getRenderName() {
        return RENDER_NAME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(String ... packages) throws IOException {
        String moduleName = this.getRenderDesc().substring(this.getRenderName().length());
        moduleName = Common.isBlank((String)moduleName) ? null : moduleName.substring(1);
        List<WebSocketModule> modules = APIHelper.loadModules(this.getRenderName(), packages);
        String contextPath = Common.isBlank((String)moduleName) ? "@concrete/" : this.getModuleName(moduleName) + "/";
        CLASSES.set(new HashMap());
        try {
            for (WebSocketModule module : modules) {
                this.process(moduleName, module);
            }
            if (!this.exists(contextPath + "AbstractConcreteService.ts")) {
                this.copyTo("abstractConcreteService.ftl", contextPath + "AbstractConcreteService.ts");
            }
            this.packages(contextPath);
        }
        finally {
            CLASSES.remove();
        }
    }

    @Override
    protected String getModuleType() {
        return "WebSocket";
    }

    @Override
    protected String getMethodPath(AbstractModule<WebSocketUnit> module, WebSocketUnit unit) {
        return unit.getKey();
    }

    @Override
    protected String getBody(WebSocketUnit unit) {
        switch (unit.getParameters().length) {
            case 0: {
                return "{}";
            }
            case 1: {
                return unit.getParameters()[0].getName();
            }
        }
        StringBuilder builder = new StringBuilder("{");
        boolean isFirst = true;
        for (AbstractParam param : unit.getParameters()) {
            if (!isFirst) {
                builder.append(", ");
            }
            builder.append(param.getName()).append(": ").append(param.getName());
            isFirst = false;
        }
        return builder.append("}").toString();
    }
}

