/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.apm.mysql;

import com.mysql.jdbc.Connection;
import com.mysql.jdbc.PreparedStatement;
import com.mysql.jdbc.ResultSetInternalMethods;
import com.mysql.jdbc.Statement;
import com.mysql.jdbc.StatementInterceptorV2;
import java.sql.SQLException;
import java.util.Properties;
import org.coodex.concrete.apm.APM;
import org.coodex.concrete.apm.Trace;

public class TracingStatementInterceptor
implements StatementInterceptorV2 {
    private static ThreadLocal<Trace> traceThreadLocal = new ThreadLocal();

    public ResultSetInternalMethods preProcess(String sql, Statement interceptedStatement, Connection connection) {
        Trace trace = APM.build();
        traceThreadLocal.set(trace);
        if (interceptedStatement instanceof PreparedStatement) {
            sql = ((PreparedStatement)interceptedStatement).getPreparedSql();
        }
        int spaceIndex = sql.indexOf(32);
        trace.tag("sql.query", sql).start(spaceIndex == -1 ? sql : sql.substring(0, spaceIndex));
        return null;
    }

    public ResultSetInternalMethods postProcess(String sql, Statement interceptedStatement, ResultSetInternalMethods originalResultSet, Connection connection, int warningCount, boolean noIndexUsed, boolean noGoodIndexUsed, SQLException statementException) {
        Trace trace = traceThreadLocal.get();
        traceThreadLocal.remove();
        if (trace != null) {
            if (statementException != null) {
                trace.error((Throwable)statementException);
            }
            trace.finish();
        }
        return null;
    }

    public boolean executeTopLevelOnly() {
        return true;
    }

    public void init(Connection conn, Properties props) {
    }

    public void destroy() {
    }
}

