/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.attachments;

import java.util.List;
import org.coodex.concrete.common.ConcreteException;
import org.coodex.util.DigestHelper;
import org.coodex.util.Profile;

public class AttachmentServiceHelper {
    public static final Profile ATTACHMENT_PROFILE = Profile.getProfile((String)"attachmentService.properties");

    public static String getKey(String clientId) {
        return ATTACHMENT_PROFILE.getString("key." + clientId, "");
    }

    public static String sign(String clientId, String attachmentId) {
        try {
            return DigestHelper.hmac((String)attachmentId, (String)AttachmentServiceHelper.getKey(clientId));
        }
        catch (Throwable t) {
            throw new ConcreteException(2001, new Object[]{t});
        }
    }

    public static String sign(String clientId, List<String> attachmentIds) {
        StringBuilder builder = new StringBuilder();
        for (String attachmentId : attachmentIds) {
            builder.append(attachmentId);
        }
        try {
            return DigestHelper.hmac((String)builder.toString(), (String)AttachmentServiceHelper.getKey(clientId));
        }
        catch (Throwable t) {
            throw new ConcreteException(2001, new Object[]{t});
        }
    }

    public static boolean verify(String clientId, String attachmentId, String sign) {
        return AttachmentServiceHelper.sign(clientId, attachmentId).equalsIgnoreCase(sign);
    }

    public static boolean verify(String clientId, List<String> attachmentIds, String sign) {
        return AttachmentServiceHelper.sign(clientId, attachmentIds).equalsIgnoreCase(sign);
    }
}

