/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.attachments.client;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.attachments.Attachment;
import org.coodex.concrete.attachments.client.ClientServiceImpl;
import org.coodex.concrete.common.RuntimeContext;
import org.coodex.concrete.core.intercept.AbstractInterceptor;
import org.coodex.concrete.jaxrs.JaxRSHelper;
import org.coodex.util.ReflectHelper;

public class AttachmentInterceptor
extends AbstractInterceptor {
    public static final int ORDER = 9002;

    public int getOrder() {
        return 9002;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object after(RuntimeContext context, MethodInvocation joinPoint, Object result) {
        try {
            HashSet<String> attachments = new HashSet<String>();
            this.grant(result, attachments, null, false);
            if (attachments.size() > 0) {
                ClientServiceImpl.allow(attachments);
            }
        }
        finally {
            return super.after(context, joinPoint, result);
        }
    }

    private void grant(Object object, Set<String> attachments, Set<Object> stack, boolean declaredAttachment) {
        if (object == null) {
            return;
        }
        if (stack == null) {
            stack = new HashSet<Object>();
        }
        if (stack.contains(object)) {
            return;
        }
        Class<?> c = object.getClass();
        if (c != String.class) {
            stack.add(object);
        }
        if (c == Object.class) {
            return;
        }
        if (c.isArray()) {
            for (Object o : (Object[])object) {
                this.grant(o, attachments, stack, declaredAttachment);
            }
        } else if (Iterable.class.isAssignableFrom(c)) {
            for (Object o : (Iterable)object) {
                this.grant(o, attachments, stack, declaredAttachment);
            }
        } else if (Map.class.isAssignableFrom(c)) {
            for (Object o : ((Map)object).values()) {
                this.grant(o, attachments, stack, declaredAttachment);
            }
        } else if (!declaredAttachment) {
            for (Field f : ReflectHelper.getAllDeclaredFields(c)) {
                f.setAccessible(true);
                if (Modifier.isStatic(f.getModifiers())) continue;
                try {
                    this.grant(f.get(object), attachments, stack, f.getAnnotation(Attachment.class) != null);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        } else if (c == String.class) {
            attachments.add((String)object);
        } else {
            if (JaxRSHelper.isPrimitive(c)) {
                return;
            }
            this.grant(object, attachments, stack, false);
        }
    }
}

