/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.attachments.client;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.coodex.concrete.attachments.AttachmentServiceHelper;
import org.coodex.concrete.attachments.client.ClientService;
import org.coodex.concrete.common.Assert;
import org.coodex.concrete.common.BeanProviderFacade;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.core.token.TokenManager;
import org.coodex.concrete.core.token.TokenWrapper;
import org.coodex.util.Common;

public class ClientServiceImpl
implements ClientService {
    private static final TokenManager tokenManager = (TokenManager)BeanProviderFacade.getBeanProvider().getBean(TokenManager.class);
    private static final Token token = TokenWrapper.getInstance();
    public static final String ATTACHMENT_AUTHORIZATION_KEY = ClientServiceImpl.class.getName() + ".AUTHORIZATIONS";
    public static final String ATTACHMENT_WRITABLE_KEY = ClientServiceImpl.class.getName() + ".WRITABLE";

    public static void allowWrite() {
        if (token.getAttribute(ATTACHMENT_WRITABLE_KEY) == null) {
            token.setAttribute(ATTACHMENT_WRITABLE_KEY, (Serializable)((Object)"OK"));
        }
    }

    public static void allow(Set<String> attachmentIds) {
        ClientServiceImpl.allow(token, attachmentIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void allow(Token token, Set<String> attachmentIds) {
        Class<ClientServiceImpl> clazz = ClientServiceImpl.class;
        synchronized (ClientServiceImpl.class) {
            HashMap<String, Long> attachments = (HashMap<String, Long>)token.getAttribute(ATTACHMENT_AUTHORIZATION_KEY);
            if (attachments == null) {
                attachments = new HashMap<String, Long>();
                token.setAttribute(ATTACHMENT_AUTHORIZATION_KEY, attachments);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            long validity = System.currentTimeMillis() + AttachmentServiceHelper.ATTACHMENT_PROFILE.getLong("attachment.validity", 10L) * 1000L * 60L;
            for (String attachmentId : attachmentIds) {
                if (attachmentId == null) continue;
                attachments.put(attachmentId, validity);
            }
            token.flush();
            return;
        }
    }

    public static void allow(String ... attachmentIds) {
        ClientServiceImpl.allow(Common.arrayToSet((Object[])attachmentIds));
    }

    private Token getTokenById(String tokenId) {
        Token token = tokenManager.getToken(tokenId);
        Assert.isNull((Object)token, (int)1003, (Object[])new Object[0]);
        Assert.not((boolean)token.isValid(), (int)1004, (Object[])new Object[]{tokenId});
        return token;
    }

    private boolean isAuthorized(String tokenId, String attachmentId) {
        Token token = this.getTokenById(tokenId);
        HashMap authorizations = (HashMap)token.getAttribute(ATTACHMENT_AUTHORIZATION_KEY);
        Long validity = (Long)authorizations.get(attachmentId);
        if (validity == null || validity < System.currentTimeMillis()) {
            authorizations.remove(attachmentId);
            token.flush();
            return false;
        }
        return true;
    }

    public boolean readable(String token, String attachmentId) {
        return this.isAuthorized(token, attachmentId);
    }

    public boolean writable(String token) {
        return this.getTokenById(token).getAttribute(ATTACHMENT_WRITABLE_KEY) != null;
    }

    public boolean deletable(String token, String attachmentId) {
        return this.writable(token) && this.readable(token, attachmentId);
    }

    public void notify(String token, String attachmentId) {
        Token t = tokenManager.getToken(token);
        if (t != null) {
            HashSet<String> set = new HashSet<String>();
            set.add(attachmentId);
            ClientServiceImpl.allow(t, set);
        }
    }
}

