/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.attachments.server;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.coodex.concrete.attachments.AttachmentEntityInfo;
import org.coodex.concrete.attachments.AttachmentServiceHelper;
import org.coodex.concrete.attachments.Repository;
import org.coodex.concrete.attachments.client.ClientService;
import org.coodex.concrete.common.Assert;
import org.coodex.concrete.common.BeanProviderFacade;
import org.coodex.concrete.jaxrs.Client;

public class AbstractDownloadResource {
    private Repository repository = (Repository)BeanProviderFacade.getBeanProvider().getBean(Repository.class);

    protected Response download(String clientId, String tokenId, final String attachmentId) throws UnsupportedEncodingException {
        AttachmentEntityInfo attachmentEntityInfo = this.repository.get(attachmentId);
        Assert.isNull((Object)attachmentEntityInfo, (int)2005, (Object[])new Object[0]);
        if (!"public".equalsIgnoreCase(AttachmentServiceHelper.ATTACHMENT_PROFILE.getString("rule.read", "public"))) {
            ClientService clientService = (ClientService)Client.getBean(ClientService.class, (String)AttachmentServiceHelper.ATTACHMENT_PROFILE.getString(clientId + ".location"));
            Assert.not((boolean)clientService.readable(tokenId, attachmentId), (int)2004, (Object[])new Object[0]);
        }
        Response.ResponseBuilder builder = Response.ok().header("Content-Type", (Object)attachmentEntityInfo.getContentType());
        builder.header("Content-Disposition", (Object)(this.getContentDispType(attachmentEntityInfo) + "; fileName=\"" + URLEncoder.encode(attachmentEntityInfo.getName(), "UTF-8") + "\""));
        final int speedLimit = AttachmentServiceHelper.ATTACHMENT_PROFILE.getInt("download.speedLimited", 1024) * 1024;
        StreamingOutput output = new StreamingOutput(){

            public void write(OutputStream output) throws IOException, WebApplicationException {
                AbstractDownloadResource.this.repository.writeTo(attachmentId, output, speedLimit > 0 ? speedLimit : Integer.MAX_VALUE);
            }
        };
        return builder.entity((Object)output).build();
    }

    private String getContentDispType(AttachmentEntityInfo resource) {
        String contentType = resource.getContentType().toLowerCase();
        return contentType.startsWith("text") || contentType.startsWith("image") ? "inline" : "attachment";
    }
}

