/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.attachments.client;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.coodex.concrete.attachments.client.ClientService;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.common.Token;
import org.coodex.concrete.core.token.TokenWrapper;
import org.coodex.config.Config;
import org.coodex.util.Clock;
import org.coodex.util.Common;

public class ClientServiceImpl
implements ClientService {
    public static final String ATTACHMENT_AUTHORIZATION_KEY = ClientServiceImpl.class.getName() + ".AUTHORIZATIONS";
    public static final String ATTACHMENT_WRITABLE_KEY = ClientServiceImpl.class.getName() + ".WRITABLE";
    private static final Token token = TokenWrapper.getInstance();

    public static void allowWrite() {
        if (token.getAttribute(ATTACHMENT_WRITABLE_KEY, Object.class) == null) {
            token.setAttribute(ATTACHMENT_WRITABLE_KEY, (Serializable)((Object)"OK"));
        }
    }

    public static void allow(Set<String> attachmentIds) {
        ClientServiceImpl.allow(token, attachmentIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void allow(Token token, Set<String> attachmentIds) {
        Class<ClientServiceImpl> clazz = ClientServiceImpl.class;
        synchronized (ClientServiceImpl.class) {
            HashMap<String, Long> attachments = (HashMap<String, Long>)token.getAttribute(ATTACHMENT_AUTHORIZATION_KEY, HashMap.class);
            if (attachments == null) {
                attachments = new HashMap<String, Long>();
                token.setAttribute(ATTACHMENT_AUTHORIZATION_KEY, attachments);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            long validity = Clock.currentTimeMillis() + (long)((Integer)Config.getValue((String)"attachment.validity", (Object)10, (String[])new String[]{"attachmentService", ConcreteHelper.getAppSet()}) * 1000 * 60);
            for (String attachmentId : attachmentIds) {
                if (attachmentId == null) continue;
                attachments.put(attachmentId, validity);
            }
            token.flush();
            return;
        }
    }

    public static void allow(String ... attachmentIds) {
        ClientServiceImpl.allow(Common.arrayToSet((Object[])attachmentIds));
    }

    private Token getTokenById(String tokenId) {
        Token token = TokenWrapper.getToken((String)tokenId);
        IF.isNull((Object)token, (int)1003, (Object[])new Object[0]);
        IF.not((boolean)token.isValid(), (int)1004, (Object[])new Object[]{tokenId});
        return token;
    }

    private boolean isAuthorized(String tokenId, String attachmentId) {
        Token token = this.getTokenById(tokenId);
        HashMap authorizations = (HashMap)token.getAttribute(ATTACHMENT_AUTHORIZATION_KEY, HashMap.class);
        Long validity = (Long)authorizations.get(attachmentId);
        if (validity == null || validity < Clock.currentTimeMillis()) {
            authorizations.remove(attachmentId);
            token.flush();
            return false;
        }
        return true;
    }

    public boolean readable(String token, String attachmentId) {
        return this.isAuthorized(token, attachmentId);
    }

    public boolean writable(String token) {
        return this.getTokenById(token).getAttribute(ATTACHMENT_WRITABLE_KEY, Object.class) != null;
    }

    public boolean deletable(String token, String attachmentId) {
        return this.writable(token) && this.readable(token, attachmentId);
    }

    public void notify(String token, String attachmentId) {
        Token t = TokenWrapper.getToken((String)token);
        if (t != null) {
            HashSet<String> set = new HashSet<String>();
            set.add(attachmentId);
            ClientServiceImpl.allow(t, set);
        }
    }
}

