/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.attachments.server;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.coodex.concrete.Client;
import org.coodex.concrete.attachments.AttachmentEntityInfo;
import org.coodex.concrete.attachments.Repository;
import org.coodex.concrete.attachments.client.ClientService;
import org.coodex.concrete.common.BeanServiceLoaderProvider;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.IF;
import org.coodex.config.Config;

public class AbstractDownloadResource {
    private Repository repository = (Repository)BeanServiceLoaderProvider.getBeanProvider().getBean(Repository.class);

    protected Response download(String clientId, String tokenId, String attachmentId) throws UnsupportedEncodingException {
        AttachmentEntityInfo attachmentEntityInfo = this.repository.get(attachmentId);
        IF.isNull((Object)attachmentEntityInfo, (int)2005, (Object[])new Object[0]);
        if (!"public".equalsIgnoreCase((String)Config.getValue((String)"rule.read", (Object)"public", (String[])new String[]{"attachmentService", ConcreteHelper.getAppSet()}))) {
            ClientService clientService = (ClientService)Client.getInstance(ClientService.class, (String)Config.get((String)(clientId + ".location"), (String[])new String[]{"attachmentService", ConcreteHelper.getAppSet()}));
            IF.not((boolean)clientService.readable(tokenId, attachmentId), (int)2004, (Object[])new Object[0]);
        }
        Response.ResponseBuilder builder = Response.ok().header("Content-Type", (Object)attachmentEntityInfo.getContentType());
        builder.header("Content-Disposition", (Object)(this.getContentDispType(attachmentEntityInfo) + "; fileName=\"" + URLEncoder.encode(attachmentEntityInfo.getName(), "UTF-8") + "\""));
        int speedLimit = (Integer)Config.getValue((String)"download.speedLimited", (Object)1024, (String[])new String[]{"attachmentService", ConcreteHelper.getAppSet()}) * 1024;
        StreamingOutput output = output1 -> this.repository.writeTo(attachmentId, output1, speedLimit > 0 ? speedLimit : Integer.MAX_VALUE);
        return builder.entity((Object)output).build();
    }

    private String getContentDispType(AttachmentEntityInfo resource) {
        String contentType = resource.getContentType().toLowerCase();
        return contentType.startsWith("text") || contentType.startsWith("image") ? "inline" : "attachment";
    }
}

