/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.attachments.server;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.coodex.concrete.attachments.AttachmentEntityInfo;
import org.coodex.concrete.attachments.AttachmentInfo;
import org.coodex.concrete.attachments.server.AbstractUploadResource;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.config.Config;
import org.coodex.util.Common;

@Path(value="attachments/upload/byform")
public class UploadByFormResource
extends AbstractUploadResource {
    @Path(value="/{clientId}/{tokenId}")
    @POST
    @Consumes(value={"application/x-www-form-urlencoded", "multipart/form-data"})
    @Produces(value={"application/json"})
    public void uploadByForm(final @Suspended AsyncResponse asyncResponse, final @Context HttpServletRequest request, final @PathParam(value="clientId") String clientId, final @PathParam(value="tokenId") String tokenId) {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    ServletFileUpload uploadHandler = new ServletFileUpload((FileItemFactory)new DiskFileItemFactory());
                    List items = uploadHandler.parseRequest(request);
                    ArrayList<AttachmentEntityInfo> result = new ArrayList<AttachmentEntityInfo>();
                    for (FileItem item : items) {
                        if (item.isFormField() || Common.isBlank((String)item.getName())) continue;
                        AttachmentInfo attachmentInfo = new AttachmentInfo();
                        attachmentInfo.setName(item.getName());
                        attachmentInfo.setOwner(clientId);
                        attachmentInfo.setSize(item.getSize());
                        attachmentInfo.setContentType(item.getContentType());
                        result.add(UploadByFormResource.this.saveToRepo(clientId, tokenId, attachmentInfo, item.getInputStream()));
                    }
                    asyncResponse.resume(result);
                }
                catch (Throwable t) {
                    asyncResponse.resume(t);
                }
            }
        });
        t.setPriority((Integer)Config.getValue((String)"upload.priority", (Object)5, (String[])new String[]{"attachmentService", ConcreteHelper.getAppSet()}));
        t.start();
    }
}

