/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.attachments.repo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.coodex.concrete.attachments.repo.FileLocation;
import org.coodex.concrete.attachments.repo.FileSummary;
import org.coodex.util.Common;
import org.csource.common.MyException;
import org.csource.common.NameValuePair;
import org.csource.fastdfs.ClientGlobal;
import org.csource.fastdfs.DownloadCallback;
import org.csource.fastdfs.StorageClient;
import org.csource.fastdfs.StorageServer;
import org.csource.fastdfs.TrackerClient;
import org.csource.fastdfs.TrackerGroup;
import org.csource.fastdfs.TrackerServer;
import org.csource.fastdfs.UploadCallback;
import org.csource.fastdfs.UploadStream;

public class FastFDSClient {
    public static final String META_FILE_NAME = "file-getName";
    private TrackerGroup trackerGroup;

    static Map<String, String> nameValuePairToMap(NameValuePair[] nameValuePairs) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (nameValuePairs != null && nameValuePairs.length > 0) {
            for (NameValuePair pair : nameValuePairs) {
                map.put(pair.getName(), pair.getValue());
            }
        }
        return map;
    }

    static NameValuePair[] mapToNameValuePairs(Map<String, String> map) {
        if (map == null) {
            return null;
        }
        HashSet<NameValuePair> set = new HashSet<NameValuePair>();
        for (String key : map.keySet()) {
            set.add(new NameValuePair(key, map.get(key)));
        }
        return set.toArray(new NameValuePair[0]);
    }

    public FastFDSClient(TrackerGroup trackerGroup) {
        this.trackerGroup = trackerGroup;
    }

    private StorageClient_ getClient(String groupName) throws IOException {
        TrackerClient trackerClient = new TrackerClient(this.trackerGroup);
        TrackerServer trackerServer = this.trackerGroup == null ? null : this.trackerGroup.getConnection();
        return new StorageClient_(trackerServer, trackerClient.getStoreStorage(trackerServer, groupName));
    }

    public FileLocation uploadFile(String filePath) throws IOException, MyException {
        return this.uploadFile(filePath, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileLocation uploadFile(String filePath, String group) throws IOException, MyException {
        File f = new File(filePath);
        if (!f.exists()) {
            throw new FileNotFoundException(filePath);
        }
        FileInputStream inputStream = new FileInputStream(f);
        try {
            FileLocation fileLocation = this.uploadFile((InputStream)inputStream, f.getName(), f.length(), group);
            return fileLocation;
        }
        finally {
            ((InputStream)inputStream).close();
        }
    }

    public FileLocation uploadFile(InputStream inputStream, String local_filename, String group) throws IOException, MyException {
        return this.uploadFile(inputStream, local_filename, 0L, group);
    }

    public FileLocation uploadFile(InputStream inputStream, String local_filename, long size, String group) throws IOException, MyException {
        return this.uploadFile(inputStream, local_filename, null, size, null, group);
    }

    public FileLocation uploadFile(InputStream inputStream, String local_filename, long size, Map<String, String> metaInfo) throws IOException, MyException {
        return this.uploadFile(inputStream, local_filename, size, metaInfo, null);
    }

    public FileLocation uploadFile(InputStream inputStream, String local_filename, long size, Map<String, String> metaInfo, String group) throws IOException, MyException {
        return this.uploadFile(inputStream, local_filename, null, size, metaInfo, group);
    }

    public FileLocation uploadFile(InputStream inputStream, String local_filename, String file_ext_name, long size, Map<String, String> meta_list, String group) throws IOException, MyException {
        HashMap<String, String> hashMap = meta_list = meta_list == null ? new HashMap<String, String>() : meta_list;
        if (file_ext_name == null) {
            if (Common.isBlank((String)local_filename)) {
                file_ext_name = "";
            } else {
                int nPos = local_filename.lastIndexOf(46);
                if (nPos > 0 && local_filename.length() - nPos <= 7) {
                    file_ext_name = local_filename.substring(nPos + 1);
                }
            }
        }
        if (meta_list != null && meta_list.get(META_FILE_NAME) == null && !Common.isBlank((String)local_filename)) {
            meta_list.put(META_FILE_NAME, local_filename);
        }
        String[] result = this.getClient(group).do_upload_file((byte)11, null, local_filename, null, file_ext_name, size <= 0L ? (long)inputStream.available() : size, new UploadStream(inputStream, size), FastFDSClient.mapToNameValuePairs(meta_list));
        return new FileLocation(result[0], result[1]);
    }

    public FileSummary getFileSummary(String group, String fileName) throws IOException, MyException {
        StorageClient_ client = this.getClient(group);
        FileSummary fileSummary = new FileSummary(client.get_file_info(group, fileName));
        fileSummary.setMetaData(FastFDSClient.nameValuePairToMap(client.get_metadata(group, fileName)));
        return fileSummary;
    }

    public FileSummary getFileSummary(FileLocation location) throws IOException, MyException {
        return this.getFileSummary(location.getGroup(), location.getPath());
    }

    public void downloadFile(FileLocation location, OutputStream outputStream) throws IOException, MyException {
        this.downloadFile(location.getGroup(), location.getPath(), outputStream);
    }

    public void downloadFile(String group, String fileName, OutputStream outputStream) throws IOException, MyException {
        this.downloadFile(group, fileName, outputStream, 0L, 0L);
    }

    public void downloadFile(String group, String fileName, final OutputStream outputStream, long offset, long length) throws IOException, MyException {
        if (outputStream == null) {
            throw new NullPointerException("stream is NULL!");
        }
        this.getClient(group).download_file(group, fileName, offset, length, new DownloadCallback(){

            @Override
            public int recv(long file_size, byte[] data, int bytes) {
                try {
                    outputStream.write(data, 0, bytes);
                    outputStream.flush();
                }
                catch (IOException e) {
                    throw new RuntimeException("write error: " + e.getLocalizedMessage(), e);
                }
                return 0;
            }
        });
    }

    public void deleteFile(FileLocation location) throws IOException, MyException {
        this.deleteFile(location.getGroup(), location.getPath());
    }

    public void deleteFile(String group, String fileName) throws IOException, MyException {
        int i = this.getClient(group).delete_file(group, fileName);
        if (i != 0) {
            throw new MyException("delete error. errorCode: " + i);
        }
    }

    public void updateFileSummary(FileLocation location, FileSummary fileSummary) throws IOException, MyException {
        this.getClient(location.getGroup()).set_metadata(location.getGroup(), location.getPath(), FastFDSClient.mapToNameValuePairs(fileSummary.getMetaData()), (byte)79);
    }

    static {
        ClientGlobal.setG_charset("UTF-8");
    }

    class StorageClient_
    extends StorageClient {
        StorageClient_(TrackerServer trackerServer, StorageServer storageServer) {
            super(trackerServer, null);
        }

        @Override
        public String[] do_upload_file(byte cmd, String group_name, String master_filename, String prefix_name, String file_ext_name, long file_size, UploadCallback callback, NameValuePair[] meta_list) throws IOException, MyException {
            return super.do_upload_file(cmd, group_name, master_filename, prefix_name, file_ext_name, file_size, callback, meta_list);
        }

        @Override
        public int do_append_file(String group_name, String appender_filename, long file_size, UploadCallback callback) throws IOException, MyException {
            return super.do_append_file(group_name, appender_filename, file_size, callback);
        }

        @Override
        public int do_modify_file(String group_name, String appender_filename, long file_offset, long modify_size, UploadCallback callback) throws IOException, MyException {
            return super.do_modify_file(group_name, appender_filename, file_offset, modify_size, callback);
        }
    }
}

