/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.attachments.repo;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.coodex.concrete.attachments.AttachmentEntityInfo;
import org.coodex.concrete.attachments.AttachmentInfo;
import org.coodex.concrete.attachments.Repository;
import org.coodex.concrete.attachments.repo.FastFDSClient;
import org.coodex.concrete.attachments.repo.FileLocation;
import org.coodex.concrete.attachments.repo.FileSummary;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.config.Config;
import org.coodex.io.SpeedLimitedOutputStream;
import org.coodex.util.Base58;
import org.coodex.util.Clock;
import org.csource.fastdfs.TrackerGroup;

public class FastDFSRepository
implements Repository {
    private static final String TAG_ATTACHMENT_SERVICE = "attachmentService";

    private static InetSocketAddress[] getTrackerAddress() {
        String[] address = Config.getArray((String)"fastdfs.tracker", (String[])new String[]{TAG_ATTACHMENT_SERVICE, ConcreteHelper.getAppSet()});
        if (address == null) {
            return null;
        }
        HashSet<InetSocketAddress> addressList = new HashSet<InetSocketAddress>();
        for (String addr : address) {
            int index = addr.indexOf(58);
            if (index <= 0) continue;
            addressList.add(new InetSocketAddress(addr.substring(0, index).trim(), (int)Integer.valueOf(addr.substring(index + 1).trim())));
        }
        return addressList.toArray(new InetSocketAddress[0]);
    }

    private FastFDSClient getClient() {
        return new FastFDSClient(new TrackerGroup(FastDFSRepository.getTrackerAddress()));
    }

    private Map<String, String> toMap(AttachmentInfo attachmentInfo) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("name", attachmentInfo.getName());
        map.put("contentType", attachmentInfo.getContentType());
        map.put("size", String.valueOf(attachmentInfo.getSize()));
        map.put("created", String.valueOf(attachmentInfo.getCreated()));
        map.put("lastUsed", String.valueOf(attachmentInfo.getLastUsed()));
        map.put("owner", String.valueOf(attachmentInfo.getOwner()));
        return map;
    }

    private void copyToInfo(AttachmentInfo attachmentInfo, Map<String, String> meta) {
        attachmentInfo.setName(meta.get("name"));
        attachmentInfo.setContentType(meta.get("contentType"));
        attachmentInfo.setSize(Long.valueOf(meta.get("size")).longValue());
        attachmentInfo.setCreated(Long.valueOf(meta.get("created")).longValue());
        attachmentInfo.setLastUsed(Long.valueOf(meta.get("lastUsed")).longValue());
        attachmentInfo.setOwner(meta.get("owner"));
    }

    private AttachmentEntityInfo copy(AttachmentInfo metaInfo) {
        AttachmentEntityInfo entityInfo = new AttachmentEntityInfo();
        entityInfo.setContentType(metaInfo.getContentType());
        entityInfo.setCreated(metaInfo.getCreated());
        entityInfo.setSize(metaInfo.getSize());
        entityInfo.setOwner(metaInfo.getOwner());
        entityInfo.setLastUsed(metaInfo.getLastUsed());
        entityInfo.setName(metaInfo.getName());
        return entityInfo;
    }

    private String toId(FileLocation location) {
        try {
            return Base58.encode((byte[])(location.getGroup() + '/' + location.getPath()).getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private FileLocation idToFileLocation(String id) {
        try {
            byte[] buf = Base58.decode((String)id);
            String s = new String(buf, "UTF-8");
            int sp = s.indexOf(47);
            return new FileLocation(s.substring(0, sp), s.substring(sp + 1));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public AttachmentEntityInfo put(InputStream content, AttachmentInfo metaInfo) {
        metaInfo.setCreated(Clock.currentTimeMillis());
        FastFDSClient client = this.getClient();
        try {
            FileLocation location = client.uploadFile(content, metaInfo.getName(), metaInfo.getSize(), this.toMap(metaInfo));
            AttachmentEntityInfo entityInfo = this.copy(metaInfo);
            entityInfo.setId(this.toId(location));
            return entityInfo;
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    protected void update(AttachmentEntityInfo entityInfo) {
        entityInfo.setLastUsed(Clock.currentTimeMillis());
        this.updateInfo(entityInfo.getId(), (AttachmentInfo)entityInfo);
    }

    public void updateInfo(String attachmentId, AttachmentInfo metaInfo) {
        try {
            FastFDSClient client = this.getClient();
            FileLocation fileLocation = this.idToFileLocation(attachmentId);
            FileSummary summary = client.getFileSummary(fileLocation);
            summary.setMetaData(this.toMap(metaInfo));
            client.updateFileSummary(fileLocation, summary);
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    public void delete(String attachmentId) {
        try {
            FileLocation fileLocation = this.idToFileLocation(attachmentId);
            this.getClient().deleteFile(fileLocation);
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    public void delete(Set<String> attachmentIds) {
        for (String id : attachmentIds) {
            this.delete(id);
        }
    }

    public AttachmentEntityInfo get(String attachmentId) {
        try {
            FileSummary summary = this.getClient().getFileSummary(this.idToFileLocation(attachmentId));
            AttachmentEntityInfo entityInfo = new AttachmentEntityInfo();
            this.copyToInfo((AttachmentInfo)entityInfo, summary.getMetaData());
            entityInfo.setId(attachmentId);
            return entityInfo;
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }

    public void writeTo(String attachmentId, OutputStream outputStream, int speedLimit) {
        try {
            FastFDSClient client = this.getClient();
            client.downloadFile(this.idToFileLocation(attachmentId), (OutputStream)new SpeedLimitedOutputStream(outputStream, speedLimit));
            AttachmentEntityInfo entityInfo = this.get(attachmentId);
            entityInfo.setLastUsed(Clock.currentTimeMillis());
            this.update(entityInfo);
        }
        catch (Throwable th) {
            throw new RuntimeException(th);
        }
    }
}

