/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client.impl;

import java.util.Stack;
import org.coodex.concrete.ClientHelper;
import org.coodex.concrete.client.Destination;
import org.coodex.concrete.client.Invoker;
import org.coodex.concrete.client.InvokerFactory;
import org.coodex.concrete.common.IF;
import org.coodex.util.Common;

public class AliasInvokerFactory
implements InvokerFactory {
    public static final String ALIAS_PROTOCOLS = "alias:";
    private static ThreadLocal<Stack<String>> stackThreadLocal = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Invoker getInvoker(Destination destination) {
        Stack<String> stack = stackThreadLocal.get();
        if (stack == null) {
            stack = new Stack();
            stackThreadLocal.set(stack);
        }
        if (stack.contains(destination.getIdentify())) {
            StringBuilder builder = new StringBuilder();
            builder.append("client alias cycle reference: ").append(destination.getIdentify()).append(" -> ");
            for (int i = stack.size() - 1; i >= 0; --i) {
                String ref = (String)stack.get(i);
                builder.append(ref);
                if (Common.isSameStr((String)ref, (String)destination.getIdentify())) break;
                builder.append(" -> ");
            }
            builder.append(".");
            IF.is((boolean)true, (String)builder.toString());
        }
        stack.push(destination.getIdentify());
        try {
            Destination aliasTo = ClientHelper.getDestination(destination.getLocation().substring(ALIAS_PROTOCOLS.length()).trim());
            Invoker invoker = ((InvokerFactory)ClientHelper.getInvokerFactoryProviders().getServiceInstance((Object)aliasTo)).getInvoker(aliasTo);
            return invoker;
        }
        finally {
            stack.pop();
        }
    }

    public boolean accept(Destination param) {
        return !Common.isBlank((String)param.getLocation()) && param.getLocation().toLowerCase().startsWith(ALIAS_PROTOCOLS);
    }
}

