/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete;

import java.util.Set;
import javax.net.ssl.SSLContext;
import org.coodex.concrete.client.Destination;
import org.coodex.concrete.client.InstanceBuilder;
import org.coodex.concrete.client.InvokerFactory;
import org.coodex.concrete.client.impl.JavaProxyInstanceBuilder;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ConcreteServiceLoader;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.common.JSONSerializer;
import org.coodex.concrete.common.JSONSerializerFactory;
import org.coodex.concrete.core.intercept.AsyncInterceptorChain;
import org.coodex.concrete.core.intercept.ConcreteInterceptor;
import org.coodex.concrete.core.intercept.InterceptorChain;
import org.coodex.concrete.core.intercept.SyncInterceptorChain;
import org.coodex.ssl.SSLContextFactory;
import org.coodex.util.AcceptableServiceLoader;
import org.coodex.util.Common;
import org.coodex.util.ServiceLoader;
import org.coodex.util.ServiceLoaderFacade;
import org.coodex.util.Singleton;

public class ClientHelper {
    public static final String TAG_CLIENT = "client";
    private static Singleton<InstanceBuilder> instanceBuilder = new Singleton((Singleton.Builder)new Singleton.Builder<InstanceBuilder>(){

        public InstanceBuilder build() {
            return (InstanceBuilder)new ConcreteServiceLoader<InstanceBuilder>(){

                protected InstanceBuilder getConcreteDefaultProvider() {
                    return new JavaProxyInstanceBuilder();
                }
            }.getInstance();
        }
    });
    private static Singleton<AcceptableServiceLoader<Destination, InvokerFactory>> invokerFactoryProviders = new Singleton((Singleton.Builder)new Singleton.Builder<AcceptableServiceLoader<Destination, InvokerFactory>>(){

        public AcceptableServiceLoader<Destination, InvokerFactory> build() {
            return new AcceptableServiceLoader((ServiceLoaderFacade)new ConcreteServiceLoader<InvokerFactory>(){});
        }
    });
    private static Singleton<AcceptableServiceLoader<String, SSLContextFactory>> sslContextFactoryAcceptableServiceLoader = new Singleton((Singleton.Builder)new Singleton.Builder<AcceptableServiceLoader<String, SSLContextFactory>>(){

        public AcceptableServiceLoader<String, SSLContextFactory> build() {
            return new AcceptableServiceLoader((ServiceLoaderFacade)new ConcreteServiceLoader<SSLContextFactory>(){});
        }
    });
    private static Singleton<ServiceLoader<ConcreteInterceptor>> interceptorServiceLoader = new Singleton((Singleton.Builder)new Singleton.Builder<ServiceLoader<ConcreteInterceptor>>(){

        public ServiceLoader<ConcreteInterceptor> build() {
            return new ConcreteServiceLoader<ConcreteInterceptor>(){};
        }
    });
    private static Singleton<SyncInterceptorChain> syncInterceptorChain = new Singleton((Singleton.Builder)new Singleton.Builder<SyncInterceptorChain>(){

        public SyncInterceptorChain build() {
            SyncInterceptorChain instance = new SyncInterceptorChain();
            ClientHelper.buildChain((Set)instance);
            return instance;
        }
    });
    private static Singleton<AsyncInterceptorChain> asyncInterceptorChain = new Singleton((Singleton.Builder)new Singleton.Builder<AsyncInterceptorChain>(){

        public AsyncInterceptorChain build() {
            AsyncInterceptorChain instance = new AsyncInterceptorChain();
            ClientHelper.buildChain((Set)instance);
            return instance;
        }
    });

    public static JSONSerializer getJSONSerializer() {
        return JSONSerializerFactory.getInstance();
    }

    public static InstanceBuilder getInstanceBuilder() {
        return (InstanceBuilder)instanceBuilder.getInstance();
    }

    public static AcceptableServiceLoader<Destination, InvokerFactory> getInvokerFactoryProviders() {
        return (AcceptableServiceLoader)invokerFactoryProviders.getInstance();
    }

    public static boolean isReactiveExtension(Class<?> clz) {
        try {
            Class<?> rx = Class.forName("org.coodex.concrete.rx.ReactiveExtensionFor");
            return clz.getAnnotation(rx) != null;
        }
        catch (Throwable th) {
            return false;
        }
    }

    public static boolean isConcreteService(Class<?> clz) {
        return ConcreteHelper.isConcreteService(clz) || ClientHelper.isReactiveExtension(clz);
    }

    public static String getString(String module, String key) {
        return ConcreteHelper.getString((String)TAG_CLIENT, (String)module, (String)key);
    }

    public static Destination getDestination(String module) {
        String location = ClientHelper.getString(module, "location");
        IF.is((boolean)Common.isBlank((String)location), (String)("location for [" + module + "] is NOT found."));
        Destination destination = new Destination();
        destination.setIdentify(module);
        destination.setLocation(location);
        destination.setTokenManagerKey(ClientHelper.getString(module, "tokenManagerKey"));
        destination.setTokenTransfer(Common.toBool((String)ClientHelper.getString(module, "tokenTransfer"), (boolean)false));
        return destination;
    }

    private static AcceptableServiceLoader<String, SSLContextFactory> getSSLContextFactoryAcceptableServiceLoader() {
        return (AcceptableServiceLoader)sslContextFactoryAcceptableServiceLoader.getInstance();
    }

    public static SSLContext getSSLContext(Destination destination) {
        String ssl = ClientHelper.getString(destination.getIdentify(), "ssl");
        try {
            return ((SSLContextFactory)ClientHelper.getSSLContextFactoryAcceptableServiceLoader().getServiceInstance((Object)ssl)).getSSLContext(ssl);
        }
        catch (Throwable th) {
            throw ConcreteHelper.getException((Throwable)th);
        }
    }

    private static ServiceLoader<ConcreteInterceptor> getInterceptorServiceLoader() {
        return (ServiceLoader)interceptorServiceLoader.getInstance();
    }

    private static void buildChain(Set<ConcreteInterceptor> chain) {
        for (ConcreteInterceptor interceptor : ClientHelper.getInterceptorServiceLoader().getAllInstances()) {
            if (interceptor instanceof InterceptorChain) continue;
            chain.add(interceptor);
        }
    }

    public static SyncInterceptorChain getSyncInterceptorChain() {
        return (SyncInterceptorChain)syncInterceptorChain.getInstance();
    }

    public static AsyncInterceptorChain getAsyncInterceptorChain() {
        return (AsyncInterceptorChain)asyncInterceptorChain.getInstance();
    }
}

