/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client.impl;

import java.lang.reflect.Method;
import org.aopalliance.intercept.MethodInvocation;
import org.coodex.closure.CallableClosure;
import org.coodex.concrete.ClientHelper;
import org.coodex.concrete.apm.APM;
import org.coodex.concrete.apm.Trace;
import org.coodex.concrete.client.ClientMethodInvocation;
import org.coodex.concrete.client.Destination;
import org.coodex.concrete.client.impl.AbstractInvoker;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.pojomocker.MockerFacade;
import org.coodex.util.Common;

public abstract class AbstractSyncInvoker
extends AbstractInvoker {
    public AbstractSyncInvoker(Destination destination) {
        super(destination);
    }

    protected abstract Object execute(Class var1, Method var2, Object[] var3) throws Throwable;

    @Override
    public Object invoke(final Object instance, final Class clz, final Method method, final Object ... args) {
        ServiceContext serviceContext = this.buildContext(clz, method);
        Trace trace = APM.build().tag("interface", clz.getName()).tag("method", method.getName()).start(String.format("client invoke: %s", this.getDestination().getLocation()));
        trace.hack(serviceContext.getSubjoin());
        try {
            Object object = ConcreteContext.runWithContext((ServiceContext)serviceContext, (CallableClosure)new CallableClosure(){

                public Object call() throws Throwable {
                    return ClientHelper.getSyncInterceptorChain().invoke((MethodInvocation)new ClientMethodInvocation(instance, clz, method, args){

                        public Object proceed() throws Throwable {
                            if (AbstractSyncInvoker.this.isMock()) {
                                return MockerFacade.mock((Method)method, (Class[])new Class[]{clz});
                            }
                            return AbstractSyncInvoker.this.execute(clz, method, args);
                        }
                    });
                }
            });
            return object;
        }
        catch (Throwable throwable) {
            trace.error(throwable);
            throw Common.runtimeException((Throwable)throwable);
        }
        finally {
            trace.finish();
        }
    }
}

