/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.client.ClientSideContext;
import org.coodex.concrete.client.WarningHandle;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.JSONSerializerFactory;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.concrete.common.SubjoinWrapper;
import org.coodex.concrete.common.Warning;
import org.coodex.concrete.common.WarningData;
import org.coodex.concrete.core.intercept.AbstractSyncInterceptor;
import org.coodex.concrete.core.intercept.annotations.ClientSide;
import org.coodex.util.Common;
import org.coodex.util.GenericTypeHelper;
import org.coodex.util.ServiceLoaderImpl;
import org.coodex.util.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ClientSide
public class WarningClientInterceptor
extends AbstractSyncInterceptor {
    private static final Logger log = LoggerFactory.getLogger(WarningClientInterceptor.class);
    private static Type type = new GenericTypeHelper.GenericType<List<WarningData>>(){}.getType();
    private static Singleton<Collection<WarningHandle>> WARNING_HANDLES = new Singleton(() -> new ServiceLoaderImpl<WarningHandle>(){}.getAll().values());

    protected boolean accept_(DefinitionContext context) {
        return true;
    }

    public int getOrder() {
        return 10000;
    }

    public Object after(DefinitionContext context, MethodInvocation joinPoint, Object result) {
        ServiceContext serviceContext = ConcreteContext.getServiceContext();
        if (serviceContext instanceof ClientSideContext) {
            List warningList;
            ClientSideContext clientSideContext = (ClientSideContext)serviceContext;
            String warnings = SubjoinWrapper.getInstance().get("CONCRETE-WARNINGS");
            if (!Common.isBlank((String)warnings) && (warningList = (List)JSONSerializerFactory.getInstance().parse(warnings, type)).size() > 0) {
                for (Warning warning : warningList) {
                    for (WarningHandle handle : (Collection)WARNING_HANDLES.get()) {
                        try {
                            handle.onWarning(clientSideContext.getDestination(), warning);
                        }
                        catch (Throwable th) {
                            log.warn(th.getLocalizedMessage(), th);
                        }
                    }
                }
            }
        }
        return result;
    }
}

