/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client.impl;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.coodex.concrete.api.rx.ReactiveExtensionFor;
import org.coodex.concrete.client.Destination;
import org.coodex.concrete.client.Invoker;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.config.Config;
import org.coodex.util.Common;

public abstract class AbstractInvoker
implements Invoker {
    private final Destination destination;

    private static Method findTargetMethod(Class targetClass, Method method) {
        Method targetMethod = null;
        for (Method m : targetClass.getMethods()) {
            if (!m.getName().equals(method.getName()) || !Arrays.equals(m.getParameterTypes(), method.getParameterTypes())) continue;
            targetMethod = m;
            break;
        }
        if (targetMethod == null) {
            throw new RuntimeException("Reactive method not found for " + targetClass.getName() + " " + method.getName());
        }
        return targetMethod;
    }

    protected static DefinitionContext getDefinitionContext(Class rxClass, Method method) {
        Class targetClass = rxClass.getAnnotation(ReactiveExtensionFor.class).value();
        Method targetMethod = AbstractInvoker.findTargetMethod(targetClass, method);
        return ConcreteHelper.getDefinitionContext((Class)targetClass, (Method)targetMethod);
    }

    public AbstractInvoker(Destination destination) {
        this.destination = destination;
    }

    public abstract ServiceContext buildContext(DefinitionContext var1);

    protected boolean isMock() {
        String key = Common.isBlank((String)this.destination.getIdentify()) ? "client" : "client." + this.destination.getIdentify();
        return (Boolean)Config.getValue((String)key, (Object)false, (String[])new String[]{"moduleMock", ConcreteHelper.getAppSet()}) != false || ConcreteHelper.isDevModel((String)key);
    }

    protected Destination getDestination() {
        return this.destination;
    }
}

