/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client.impl;

import java.lang.reflect.Type;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeoutException;
import org.coodex.concrete.ClientException;
import org.coodex.concrete.ClientHelper;
import org.coodex.concrete.client.ClientSideContext;
import org.coodex.concrete.client.ClientTokenManagement;
import org.coodex.concrete.client.Destination;
import org.coodex.concrete.client.impl.AbstractRxInvoker;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.ErrorInfo;
import org.coodex.concrete.common.JSONSerializer;
import org.coodex.concrete.common.JSONSerializerFactory;
import org.coodex.concrete.common.Subjoin;
import org.coodex.concrete.core.Level;
import org.coodex.concrete.own.MapSubjoin;
import org.coodex.concrete.own.OwnServiceUnit;
import org.coodex.concrete.own.PackageHelper;
import org.coodex.concrete.own.RequestPackage;
import org.coodex.concrete.own.ResponsePackage;
import org.coodex.concurrent.TimeLimitedMap;
import org.coodex.util.Common;
import org.coodex.util.GenericTypeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOwnRxInvoker
extends AbstractRxInvoker {
    private static final Logger log = LoggerFactory.getLogger(AbstractOwnRxInvoker.class);
    private static TimeLimitedMap<String, CompletableFutureCallBack> callbackMap = new TimeLimitedMap();

    protected static JSONSerializer getSerializer() {
        return JSONSerializerFactory.getInstance();
    }

    public AbstractOwnRxInvoker(Destination destination) {
        super(destination);
    }

    private static ResponsePackage<Object> parse(String responseMessage) {
        try {
            return (ResponsePackage)AbstractOwnRxInvoker.getSerializer().parse(responseMessage, new GenericTypeHelper.GenericType<ResponsePackage<Object>>(){}.getType());
        }
        catch (Throwable throwable) {
            log.warn("cannot parse ResponsePackage: {}", (Object)responseMessage, (Object)throwable);
            return null;
        }
    }

    static void processMessage(String message) {
        Object throwable;
        CompletableFutureCallBack completableFutureCallBack;
        block11: {
            Logger logger;
            ResponsePackage<Object> responsePackage = AbstractOwnRxInvoker.parse(message);
            if (responsePackage == null) {
                return;
            }
            completableFutureCallBack = (CompletableFutureCallBack)callbackMap.getAndRemove((Object)responsePackage.getMsgId());
            if (completableFutureCallBack == null) {
                log.debug("drop message: {}", (Object)message);
                return;
            }
            Level level = completableFutureCallBack.getLoggingLevel();
            if (level.isEnabled(logger = completableFutureCallBack.getLogger())) {
                level.log(logger, "message received: " + message);
            }
            throwable = null;
            if (responsePackage.isOk()) {
                completableFutureCallBack.getClientSideContext().responseSubjoin((Subjoin)new MapSubjoin(responsePackage.getSubjoin()));
                try {
                    ClientTokenManagement.setTokenId((Destination)completableFutureCallBack.getDestination(), (String)responsePackage.getConcreteTokenId());
                    if (responsePackage.getContent() == null || Void.TYPE.equals(completableFutureCallBack.getContext().getDeclaringMethod().getReturnType())) {
                        completableFutureCallBack.getCompletableFuture().complete(null);
                        break block11;
                    }
                    Object result = AbstractOwnRxInvoker.getSerializer().parse(responsePackage.getContent(), GenericTypeHelper.toReference((Type)completableFutureCallBack.getContext().getDeclaringMethod().getGenericReturnType(), (Type)completableFutureCallBack.getContext().getDeclaringClass()));
                    completableFutureCallBack.getCompletableFuture().complete(result);
                }
                catch (Throwable th) {
                    throwable = th;
                }
            } else {
                try {
                    throwable = new ClientException((ErrorInfo)AbstractOwnRxInvoker.getSerializer().parse(responsePackage.getContent(), ErrorInfo.class));
                }
                catch (Throwable th) {
                    throwable = th;
                }
            }
        }
        if (throwable != null) {
            completableFutureCallBack.getCompletableFuture().completeExceptionally((Throwable)throwable);
        }
    }

    protected abstract ClientSideContext getContext();

    protected abstract OwnServiceUnit findUnit(DefinitionContext var1);

    protected abstract Level getLoggingLevel();

    @Override
    protected CompletableFuture futureInvoke(DefinitionContext runtimeContext, Object[] args) {
        CompletableFuture completableFuture = new CompletableFuture();
        ClientHelper.getRxClientScheduler().execute(() -> {
            OwnServiceUnit unit = this.findUnit(runtimeContext);
            String msgId = Common.getUUIDStr();
            RequestPackage requestPackage = PackageHelper.buildRequest((String)msgId, (OwnServiceUnit)unit, (Object[])args);
            CompletableFutureCallBack observableCallBack = new CompletableFutureCallBack(completableFuture, runtimeContext, this.getLogger(), this.getLoggingLevel(), this.getDestination(), this.getContext());
            callbackMap.put((Object)msgId, (Object)observableCallBack, (long)this.getDestination().getTimeout().intValue(), () -> completableFuture.completeExceptionally(new TimeoutException()));
            try {
                requestPackage.setConcreteTokenId(ClientTokenManagement.getTokenId((Destination)this.getDestination(), (String)this.getContext().getTokenId()));
                this.send(requestPackage);
            }
            catch (Throwable th) {
                callbackMap.getAndRemove((Object)msgId);
                completableFuture.completeExceptionally(th);
            }
        });
        return completableFuture;
    }

    protected abstract Logger getLogger();

    protected abstract void send(RequestPackage var1) throws Throwable;

    private static class CompletableFutureCallBack
    extends BaseCallBack {
        private final CompletableFuture completableFuture;

        private CompletableFutureCallBack(CompletableFuture completableFuture, DefinitionContext context, Logger logger, Level loggingLevel, Destination destination, ClientSideContext clientSideContext) {
            super(context, logger, loggingLevel, destination, clientSideContext);
            this.completableFuture = completableFuture;
        }

        public CompletableFuture getCompletableFuture() {
            return this.completableFuture;
        }
    }

    private static class BaseCallBack {
        private final DefinitionContext context;
        private final Logger logger;
        private final Level loggingLevel;
        private final Destination destination;
        private final ClientSideContext clientSideContext;

        private BaseCallBack(DefinitionContext context, Logger logger, Level loggingLevel, Destination destination, ClientSideContext clientSideContext) {
            this.context = context;
            this.logger = logger;
            this.loggingLevel = loggingLevel;
            this.destination = destination;
            this.clientSideContext = clientSideContext;
        }

        public DefinitionContext getContext() {
            return this.context;
        }

        public Logger getLogger() {
            return this.logger;
        }

        public Destination getDestination() {
            return this.destination;
        }

        public Level getLoggingLevel() {
            return this.loggingLevel;
        }

        public ClientSideContext getClientSideContext() {
            return this.clientSideContext;
        }
    }
}

