/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.ClientHelper;
import org.coodex.concrete.apm.APM;
import org.coodex.concrete.apm.Trace;
import org.coodex.concrete.client.ClientMethodInvocation;
import org.coodex.concrete.client.Destination;
import org.coodex.concrete.client.impl.AbstractInvoker;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.mock.Mocker;
import org.coodex.util.Common;

public abstract class AbstractSyncInvoker
extends AbstractInvoker {
    public AbstractSyncInvoker(Destination destination) {
        super(destination);
    }

    protected abstract Object execute(Class var1, Method var2, Object[] var3) throws Throwable;

    @Override
    public Object invoke(Object instance, final Class clz, final Method method, final Object ... args) {
        ServiceContext serviceContext = this.buildContext(ConcreteHelper.getDefinitionContext((Class)clz, (Method)method));
        Trace trace = APM.build().tag("interface", clz.getName()).tag("method", method.getName()).start(String.format("client invoke: %s", this.getDestination().getLocation()));
        trace.hack(serviceContext.getSubjoin());
        try {
            Object object = ConcreteContext.runWithContext((ServiceContext)serviceContext, () -> ClientHelper.getSyncInterceptorChain().invoke((MethodInvocation)new ClientMethodInvocation(instance, clz, method, args){

                public Object proceed() throws Throwable {
                    if (AbstractSyncInvoker.this.isMock()) {
                        return Mocker.mockMethod((Method)method, (Type)clz);
                    }
                    return AbstractSyncInvoker.this.execute(clz, method, args);
                }
            }));
            return object;
        }
        catch (Throwable throwable) {
            trace.error(throwable);
            throw Common.runtimeException((Throwable)throwable);
        }
        finally {
            trace.finish();
        }
    }
}

