/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete;

import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import javax.net.ssl.SSLContext;
import org.coodex.concrete.api.rx.CompletableFutureBridge;
import org.coodex.concrete.api.rx.ReactiveExtensionFor;
import org.coodex.concrete.client.Destination;
import org.coodex.concrete.client.DestinationFactory;
import org.coodex.concrete.client.InstanceBuilder;
import org.coodex.concrete.client.Invoker;
import org.coodex.concrete.client.InvokerFactory;
import org.coodex.concrete.client.impl.JavaProxyInstanceBuilder;
import org.coodex.concrete.common.ConcreteHelper;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.common.JSONSerializer;
import org.coodex.concrete.common.JSONSerializerFactory;
import org.coodex.concrete.core.intercept.AsyncInterceptorChain;
import org.coodex.concrete.core.intercept.ConcreteInterceptor;
import org.coodex.concrete.core.intercept.InterceptorChain;
import org.coodex.concrete.core.intercept.SyncInterceptorChain;
import org.coodex.ssl.SSLContextFactory;
import org.coodex.util.LazySelectableServiceLoader;
import org.coodex.util.LazyServiceLoader;
import org.coodex.util.SelectableFactoryLoader;
import org.coodex.util.SelectableFactoryLoaderImpl;
import org.coodex.util.ServiceLoaderImpl;
import org.coodex.util.Singleton;

public class ClientHelper {
    private static final Singleton<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_SINGLETON = new Singleton(() -> ConcreteHelper.getScheduler((String)"rx-client"));
    private static final LazySelectableServiceLoader<Class, CompletableFutureBridge> BRIDGE_LOADER = new LazySelectableServiceLoader<Class, CompletableFutureBridge>(){};
    private static Singleton<InstanceBuilder> instanceBuilder = new Singleton(() -> (InstanceBuilder)new ServiceLoaderImpl<InstanceBuilder>((InstanceBuilder)new JavaProxyInstanceBuilder()){}.get());
    private static LazySelectableServiceLoader<Destination, InvokerFactory> invokerFactoryProviders = new LazySelectableServiceLoader<Destination, InvokerFactory>(){};
    private static LazySelectableServiceLoader<String, SSLContextFactory> sslContextFactoryAcceptableServiceLoader = new LazySelectableServiceLoader<String, SSLContextFactory>(){};
    private static LazyServiceLoader<ConcreteInterceptor> interceptorServiceLoader = new LazyServiceLoader<ConcreteInterceptor>(){};
    private static Singleton<SyncInterceptorChain> syncInterceptorChain = new Singleton(() -> {
        SyncInterceptorChain instance = new SyncInterceptorChain();
        ClientHelper.buildChain((Set<ConcreteInterceptor>)instance);
        return instance;
    });
    private static Singleton<AsyncInterceptorChain> asyncInterceptorChain = new Singleton(() -> {
        AsyncInterceptorChain instance = new AsyncInterceptorChain();
        ClientHelper.buildChain((Set<ConcreteInterceptor>)instance);
        return instance;
    });
    private static SelectableFactoryLoader<String, Destination, DestinationFactory<Destination, String>> destinationFactorySelectableServiceLoader = new SelectableFactoryLoaderImpl<String, Destination, DestinationFactory<Destination, String>>(){};

    private ClientHelper() {
    }

    public static JSONSerializer getJSONSerializer() {
        return JSONSerializerFactory.getInstance();
    }

    public static InstanceBuilder getInstanceBuilder() {
        return (InstanceBuilder)instanceBuilder.get();
    }

    public static boolean isReactiveExtension(Class<?> clz) {
        try {
            Class<?> rx = Class.forName("org.coodex.concrete.rx.ReactiveExtensionFor");
            return clz.getAnnotation(rx) != null;
        }
        catch (Throwable th) {
            return false;
        }
    }

    public static boolean isConcreteService(Class<?> clz) {
        return ConcreteHelper.isConcreteService(clz) || ClientHelper.isReactiveExtension(clz);
    }

    public static String getString(String module, String key) {
        return ConcreteHelper.getString((String)"client", (String)module, (String)key);
    }

    public static Destination getDestination(String module) {
        return (Destination)destinationFactorySelectableServiceLoader.build((Object)module);
    }

    public static SSLContext getSSLContext(String ssl) {
        try {
            return ((SSLContextFactory)sslContextFactoryAcceptableServiceLoader.select((Object)ssl)).getSSLContext(ssl);
        }
        catch (Throwable th) {
            throw ConcreteHelper.getException((Throwable)th);
        }
    }

    @Deprecated
    public static SSLContext getSSLContext(Destination destination) {
        String ssl = ClientHelper.getString(destination.getIdentify(), "ssl");
        try {
            return ((SSLContextFactory)sslContextFactoryAcceptableServiceLoader.select((Object)ssl)).getSSLContext(ssl);
        }
        catch (Throwable th) {
            throw ConcreteHelper.getException((Throwable)th);
        }
    }

    private static void buildChain(Set<ConcreteInterceptor> chain) {
        for (ConcreteInterceptor interceptor : interceptorServiceLoader.getAll().values()) {
            if (interceptor instanceof InterceptorChain) continue;
            chain.add(interceptor);
        }
    }

    public static SyncInterceptorChain getSyncInterceptorChain() {
        return (SyncInterceptorChain)syncInterceptorChain.get();
    }

    public static AsyncInterceptorChain getAsyncInterceptorChain() {
        return (AsyncInterceptorChain)asyncInterceptorChain.get();
    }

    public static Invoker getInvoker(Destination destination, Class<?> clazz) {
        InvokerFactory invokerFactory = (InvokerFactory)IF.isNull((Object)invokerFactoryProviders.select((Object)destination), (String)("Cannot found InvokerFactory for " + destination.toString()));
        return clazz.getAnnotation(ReactiveExtensionFor.class) == null ? invokerFactory.getSyncInvoker(destination) : invokerFactory.getRxInvoker(destination);
    }

    public static ScheduledExecutorService getRxClientScheduler() {
        return (ScheduledExecutorService)SCHEDULED_EXECUTOR_SERVICE_SINGLETON.get();
    }

    public static CompletableFutureBridge getCompletableFutureBridge(Class<?> type) {
        return (CompletableFutureBridge)BRIDGE_LOADER.select(type);
    }
}

