/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client.impl;

import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.aopalliance.intercept.MethodInvocation;
import org.coodex.concrete.ClientHelper;
import org.coodex.concrete.api.rx.CompletableFutureBridge;
import org.coodex.concrete.apm.APM;
import org.coodex.concrete.apm.Trace;
import org.coodex.concrete.client.Destination;
import org.coodex.concrete.client.RxInvoker;
import org.coodex.concrete.client.impl.AbstractInvoker;
import org.coodex.concrete.client.impl.RXMethodInvocation;
import org.coodex.concrete.common.ConcreteContext;
import org.coodex.concrete.common.DefinitionContext;
import org.coodex.concrete.common.ServiceContext;
import org.coodex.util.Common;

public abstract class AbstractRxInvoker
extends AbstractInvoker
implements RxInvoker {
    public AbstractRxInvoker(Destination destination) {
        super(destination);
    }

    public static Object buildSyncInstance(Class targetClass) {
        return Proxy.newProxyInstance(targetClass.getClassLoader(), new Class[]{targetClass}, (proxy1, method, args) -> {
            if (method.getDeclaringClass().equals(Object.class)) {
                return method.invoke(proxy1, args);
            }
            throw new RuntimeException("method " + method.getName() + " not implement.");
        });
    }

    @Override
    public Object invoke(Object instance, Class clz, Method method, Object ... args) {
        CompletableFutureBridge bridge = ClientHelper.getCompletableFutureBridge(method.getReturnType());
        if (bridge == null) {
            throw new RuntimeException("none completableFutureBridge found:" + method.getReturnType());
        }
        return bridge.bridging(this.invokeAsync(instance, clz, method, args));
    }

    @Override
    public CompletableFuture invokeAsync(Object instance, Class clz, Method method, Object ... args) {
        DefinitionContext runtimeContext = AbstractRxInvoker.getDefinitionContext(clz, method);
        ServiceContext serviceContext = this.buildContext(runtimeContext);
        RXMethodInvocation invocation = new RXMethodInvocation(runtimeContext, args);
        Trace trace = APM.build();
        trace.start();
        try {
            ConcreteContext.runWithContext((ServiceContext)serviceContext, () -> AbstractRxInvoker.lambda$invokeAsync$1(runtimeContext, (MethodInvocation)invocation));
        }
        catch (Throwable th) {
            trace.error(th);
            trace.finish();
            throw Common.runtimeException((Throwable)th);
        }
        return this.wrap(serviceContext, (MethodInvocation)invocation, runtimeContext, this.futureInvoke(runtimeContext, args), trace);
    }

    private CompletableFuture wrap(ServiceContext serviceContext, MethodInvocation invocation, DefinitionContext runtimeContext, CompletableFuture future, Trace trace) {
        return future.handleAsync((o, throwable) -> {
            if (throwable != null) {
                trace.error(throwable);
                try {
                    throw Common.runtimeException((Throwable)throwable);
                }
                catch (Throwable throwable2) {
                    trace.finish();
                    throw throwable2;
                }
            }
            try {
                Object object = ConcreteContext.runWithContext((ServiceContext)serviceContext, () -> ClientHelper.getAsyncInterceptorChain().after(runtimeContext, invocation, o));
                return object;
            }
            catch (Throwable th) {
                trace.error(th);
                throw Common.runtimeException((Throwable)th);
            }
            finally {
                trace.finish();
            }
        }, (Executor)ClientHelper.getRxClientScheduler());
    }

    protected abstract CompletableFuture futureInvoke(DefinitionContext var1, Object[] var2);

    private static /* synthetic */ Object lambda$invokeAsync$1(DefinitionContext runtimeContext, MethodInvocation invocation) throws Throwable {
        ClientHelper.getAsyncInterceptorChain().before(runtimeContext, invocation);
        return null;
    }
}

