/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.client.impl;

import java.util.Stack;
import org.coodex.concrete.ClientHelper;
import org.coodex.concrete.client.AbstractDestinationFactory;
import org.coodex.concrete.client.Destination;
import org.coodex.util.Common;

public class AliasDesitinationFactory
extends AbstractDestinationFactory<Destination> {
    public static final String ALIAS_PROTOCOLS = "alias:";
    private static ThreadLocal<Stack<String>> stackThreadLocal = new ThreadLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Destination build(String module) {
        Stack<String> stack = stackThreadLocal.get();
        if (stack == null) {
            stack = new Stack();
            stackThreadLocal.set(stack);
        }
        if (stack.contains(module)) {
            StringBuilder builder = new StringBuilder();
            builder.append("client alias cycle reference: ").append(module).append(" -> ");
            for (int i = stack.size() - 1; i >= 0; --i) {
                String ref = (String)stack.get(i);
                builder.append(ref);
                if (Common.isSameStr((String)ref, (String)module)) break;
                builder.append(" -> ");
            }
            builder.append(".");
            throw new RuntimeException(builder.toString());
        }
        stack.push(module);
        try {
            Destination destination = ClientHelper.getDestination(this.getLocation(module).substring(ALIAS_PROTOCOLS.length()).trim());
            return destination;
        }
        finally {
            stack.pop();
        }
    }

    public boolean accept(String module) {
        String location = this.getLocation(module);
        return !Common.isBlank((String)location) && location.toLowerCase().startsWith(ALIAS_PROTOCOLS);
    }
}

