/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.concrete.spring.components;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.inject.Inject;
import javax.inject.Named;
import org.coodex.concrete.Client;
import org.coodex.concrete.ClientHelper;
import org.coodex.concrete.ConcreteClient;
import org.coodex.concrete.common.IF;
import org.coodex.concrete.common.bytecode.javassist.JavassistHelper;
import org.coodex.util.Common;
import org.coodex.util.ReflectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;

@Named
public class ConcreteClientBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter {
    private static final Logger log = LoggerFactory.getLogger(ConcreteClientBeanPostProcessor.class);
    private static final String GET_INSTANCE = "__getConcreteServiceInstance";
    @Inject
    private DefaultListableBeanFactory defaultListableBeanFactory;
    private Set<String> registered = new HashSet<String>();
    private Map<String, Integer> moduleMap = new HashMap<String, Integer>();
    private AtomicInteger atomicInteger = new AtomicInteger(1);

    private void scan(Annotation[][] annotations, Class[] parameters) {
        for (int i = 0; i < annotations.length; ++i) {
            if (annotations[i] == null) continue;
            for (Annotation annotation : annotations[i]) {
                if (!(annotation instanceof ConcreteClient)) continue;
                this.register(parameters[i], (ConcreteClient)annotation);
            }
        }
    }

    public Object postProcessBeforeInstantiation(Class<?> beanClass, String beanName) throws BeansException {
        this.scanAndRegisterClientBean(beanClass);
        return super.postProcessBeforeInstantiation(beanClass, beanName);
    }

    private void scanAndRegisterClientBean(Class<?> beanClass) {
        for (Constructor<?> constructor : beanClass.getConstructors()) {
            this.scan(constructor.getParameterAnnotations(), constructor.getParameterTypes());
        }
        for (Executable executable : beanClass.getMethods()) {
            this.scan(((Method)executable).getParameterAnnotations(), ((Method)executable).getParameterTypes());
        }
        for (AccessibleObject accessibleObject : ReflectHelper.getAllDeclaredFields(beanClass)) {
            ConcreteClient concreteClient = ((Field)accessibleObject).getAnnotation(ConcreteClient.class);
            if (concreteClient == null) continue;
            this.register(((Field)accessibleObject).getType(), concreteClient);
        }
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        this.scanAndRegisterClientBean(bean.getClass());
        return super.postProcessAfterInstantiation(bean, beanName);
    }

    private Integer getModuleIndex(String v) {
        String hash = Common.sha1((String)v);
        if (!this.moduleMap.containsKey(hash)) {
            this.moduleMap.put(hash, this.atomicInteger.getAndIncrement());
        }
        return this.moduleMap.get(hash);
    }

    private javassist.bytecode.annotation.Annotation concreteClient(ConcreteClient concreteClient, ConstPool constPool) {
        javassist.bytecode.annotation.Annotation annotation = new javassist.bytecode.annotation.Annotation(ConcreteClient.class.getName(), constPool);
        annotation.addMemberValue("value", (MemberValue)new StringMemberValue(concreteClient.value(), constPool));
        return annotation;
    }

    private CtClass[] getParameterTypes(Method method, ClassPool classPool) {
        ArrayList<CtClass> list = new ArrayList<CtClass>();
        for (Class<?> c : method.getParameterTypes()) {
            list.add(classPool.getOrNull(c.getName()));
        }
        return list.toArray(new CtClass[0]);
    }

    private synchronized void register(Class<?> concreteService, ConcreteClient concreteClient) {
        IF.not((boolean)ClientHelper.isConcreteService(concreteService), (String)(concreteService + "is NOT ConcreteService."));
        ClassPool classPool = ClassPool.getDefault();
        String className = concreteService.getName();
        String newClassName = className + "$CBC$" + this.getModuleIndex(concreteClient.value());
        if (this.registered.contains(newClassName)) {
            return;
        }
        try {
            CtClass ctClass = classPool.makeClass(newClassName);
            ctClass.setInterfaces(new CtClass[]{classPool.getOrNull(concreteService.getName())});
            ClassFile classFile = ctClass.getClassFile();
            ConstPool constPool = classFile.getConstPool();
            classFile.setVersionToJava5();
            classFile.addAttribute((AttributeInfo)JavassistHelper.aggregate((ConstPool)constPool, (javassist.bytecode.annotation.Annotation[])new javassist.bytecode.annotation.Annotation[]{this.concreteClient(concreteClient, constPool)}));
            CtMethod ctMethod = new CtMethod(classPool.getOrNull(concreteService.getName()), GET_INSTANCE, new CtClass[0], ctClass);
            ctMethod.setModifiers(2);
            String moduleForSrc = Common.isBlank((String)concreteClient.value()) ? "null" : "\"" + concreteClient.value() + "\"";
            ctMethod.setBody("return " + Client.class.getName() + ".getInstance(" + className + ".class, " + moduleForSrc + ");");
            ctClass.addMethod(ctMethod);
            for (Method method : concreteService.getMethods()) {
                Class<?> returnType = method.getReturnType();
                ctMethod = new CtMethod(classPool.getOrNull(returnType.getName()), method.getName(), this.getParameterTypes(method, classPool), ctClass);
                StringBuilder builder = new StringBuilder();
                if (!Void.TYPE.equals(returnType)) {
                    builder.append("return ");
                }
                builder.append(GET_INSTANCE).append("().").append(method.getName()).append("(");
                if (method.getParameterTypes().length > 0) {
                    builder.append("$$");
                }
                builder.append(");");
                ctMethod.setBody(builder.toString());
                ctClass.addMethod(ctMethod);
            }
            Class generated = (Boolean)JavassistHelper.IS_JAVA_9_AND_LAST.get() != false ? ctClass.toClass(concreteService) : ctClass.toClass();
            BeanDefinitionBuilder beanDefinitionBuilder = BeanDefinitionBuilder.genericBeanDefinition((Class)generated);
            this.defaultListableBeanFactory.registerBeanDefinition("cbc_" + Common.sha1((String)newClassName), (BeanDefinition)beanDefinitionBuilder.getBeanDefinition());
            this.registered.add(newClassName);
            log.info("ConcreteClient Bean[className: {}, module: {}] registered.", (Object)newClassName, (Object)concreteClient.value());
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }
}

