/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.commons.jpa.springdata;

import java.util.Arrays;
import java.util.Collection;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.coodex.commons.jpa.criteria.Operators;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.Specifications;

public class SpecCommon {
    public static <ATTR, E> Path<ATTR> getPath(Root<E> root, String attrName) {
        Join f = null;
        String[] nodes = attrName.split("\\.");
        String attr = null;
        if (nodes.length == 1) {
            f = root;
            attr = attrName;
        } else {
            for (int i = 0; i < nodes.length; ++i) {
                attr = nodes[i];
                if (i >= nodes.length - 1) continue;
                f = root.join(attr);
            }
        }
        return f.get(attr);
    }

    public static <T> Specification<T> not(final Specification<T> spec) {
        return new Specification<T>(){

            public Predicate toPredicate(Root<T> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
                return cb.not((Expression)spec.toPredicate(root, query, cb));
            }
        };
    }

    public static <T> Specifications<T> and(Specification<T> ... specifications) {
        return SpecCommon.and(Arrays.asList(specifications));
    }

    public static <T> Specifications<T> or(Specification<T> ... specifications) {
        return SpecCommon.or(Arrays.asList(specifications));
    }

    public static <T> Specifications<T> and(Collection<Specification<T>> specList) {
        Specifications specs = null;
        for (Specification<T> s : specList) {
            if (specs != null) {
                specs = specs.and(s);
                continue;
            }
            specs = Specifications.where(s);
        }
        return specs;
    }

    public static <T> Specifications<T> or(Collection<Specification<T>> specList) {
        Specifications specs = null;
        for (Specification<T> s : specList) {
            if (specs != null) {
                specs = specs.or(s);
                continue;
            }
            specs = Specifications.where(s);
        }
        return specs;
    }

    public static <ATTR, ENTITY> Specification<ENTITY> spec(Class<ENTITY> entityClass, Operators.Logical logical, String attributeName, ATTR ... attributes) {
        return new Spec(logical, attributeName, attributes);
    }

    public static <ATTR, ENTITY> Specification<ENTITY> spec(Operators.Logical logical, String attributeName, ATTR ... attributes) {
        return new Spec(logical, attributeName, attributes);
    }

    public static <ATTR, ENTITY> Specification<ENTITY> memberOf(Class<ENTITY> entityClass, String attributeName, ATTR attr) {
        return new MemberOfSpec(attributeName, attr);
    }

    public static <ATTR, ENTITY> Specification<ENTITY> memberOf(String attributeName, ATTR attr) {
        return new MemberOfSpec(attributeName, attr);
    }

    static class Spec<ATTR, ENTITY>
    implements Specification<ENTITY> {
        private final Operators.Logical logical;
        private final ATTR[] attributes;
        private final String attributeName;

        Spec(Operators.Logical logical, String attributeName, ATTR ... attributes) {
            this.logical = logical;
            this.attributeName = attributeName;
            this.attributes = attributes;
        }

        public Predicate toPredicate(Root<ENTITY> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
            Path path = SpecCommon.getPath(root, this.attributeName);
            return this.logical.getOperator().toPredicate(path, cb, this.attributes);
        }

        protected ATTR[] getAttributes() {
            return this.attributes;
        }

        protected String getAttributeName() {
            return this.attributeName;
        }
    }

    static class MemberOfSpec<ATTR, ENTITY>
    implements Specification<ENTITY> {
        private final ATTR attr;
        private final String attributeName;

        MemberOfSpec(String attributeName, ATTR attr) {
            this.attr = attr;
            this.attributeName = attributeName;
        }

        public Predicate toPredicate(Root<ENTITY> root, CriteriaQuery<?> query, CriteriaBuilder cb) {
            Path path = SpecCommon.getPath(root, this.attributeName);
            return cb.isMember(this.attr, path);
        }
    }
}

