/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.commons.jpa.springdata;

import java.lang.reflect.Method;
import org.coodex.commons.jpa.springdata.MakerFunction;
import org.coodex.commons.jpa.springdata.SpecCommon;
import org.coodex.commons.jpa.springdata.SpecificationsMaker;
import org.coodex.concrete.common.Assert;
import org.coodex.concrete.common.ConcreteHelper;
import org.springframework.data.jpa.domain.Specifications;

public abstract class AbstractSpecificationsMaker<C, T>
implements SpecificationsMaker<C, T> {
    @Override
    public Specifications<T> make(C condition) {
        return SpecCommon.wrapper(this.make(condition, null));
    }

    public Specifications<T> make(C condition, String name) {
        name = name == null ? "" : name;
        Assert.is((boolean)name.equals("make"), (String)"Invalid SpecificationsMaker function name: make");
        Method makerFunction = null;
        for (Method method : this.getClass().getMethods()) {
            String functionName;
            MakerFunction function = method.getAnnotation(MakerFunction.class);
            String string = functionName = function == null ? method.getName() : function.value();
            if (!this.isMakerFunction(method) || !functionName.equals(name)) continue;
            makerFunction = method;
            break;
        }
        try {
            Method method = (Method)Assert.isNull(makerFunction, (String)("SpecificationsMaker function not exists: " + name));
            method.setAccessible(true);
            return (Specifications)method.invoke((Object)this, condition);
        }
        catch (Throwable th) {
            throw ConcreteHelper.getException((Throwable)th);
        }
    }

    private boolean isMakerFunction(Method method) {
        return AbstractSpecificationsMaker.class.isAssignableFrom(method.getDeclaringClass());
    }
}

