/*
 * Decompiled with CFR 0.152.
 */
package org.coodex.commons.jpa.springdata;

import java.util.ArrayList;
import org.coodex.concrete.api.pojo.PageRequest;
import org.coodex.concrete.api.pojo.PageResult;
import org.coodex.copier.Copier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;

public class PageHelper {
    public static Pageable getPageable(PageRequest pageRequest) {
        return PageHelper.getPageable(pageRequest, null);
    }

    public static Pageable getPageable(PageRequest pageRequest, Sort sort) {
        int pageNo = pageRequest.getNum() != null && pageRequest.getNum() > 0L ? pageRequest.getNum().intValue() - 1 : 0;
        return org.springframework.data.domain.PageRequest.of((int)pageNo, (int)pageRequest.getPageSize(), (Sort)sort);
    }

    public static <SRC, TARGET> PageResult<TARGET> copy(Page<SRC> srcPage, Copier<SRC, TARGET> copier) {
        PageResult result = new PageResult();
        result.setCount(Long.valueOf(srcPage.getTotalElements()));
        result.setTotal(Long.valueOf(srcPage.getTotalPages()));
        result.setNum(Long.valueOf((long)srcPage.getNumber() + 1L));
        result.setPageSize(Integer.valueOf(srcPage.getSize()));
        result.setList(new ArrayList());
        srcPage.get().forEachOrdered(src -> result.getList().add(copier.copy(src)));
        return result;
    }
}

